/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.javafx.controller;

import de.edgesoft.edgeutils.files.Resources;
import java.util.Map;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.AnchorPane;

public class CopyTextPane
extends AnchorPane {
    public static final String COPY_BUTTON = "icons/actions/edit-copy.svg";

    public static CopyTextPane createInstance(Labeled theContentLabel, String theCopyButton, boolean showCopyButton) {
        return new CopyTextPane(theContentLabel, theCopyButton, showCopyButton);
    }

    public static CopyTextPane createInstance(Labeled theContentLabel) {
        return CopyTextPane.createInstance(theContentLabel, null, false);
    }

    public static CopyTextPane createInstance(Labeled theContentLabel, boolean showCopyButton) {
        return CopyTextPane.createInstance(theContentLabel, null, showCopyButton);
    }

    public static CopyTextPane createInstance(Labeled theContentLabel, String theCopyButton) {
        return CopyTextPane.createInstance(theContentLabel, theCopyButton, true);
    }

    public static CopyTextPane createInstance(String theContentText, String theCopyButton, boolean showCopyButton) {
        return CopyTextPane.createInstance((Labeled)new Label(theContentText), theCopyButton, showCopyButton);
    }

    public static CopyTextPane createInstance(String theContentText, String theCopyButton) {
        return CopyTextPane.createInstance(theContentText, theCopyButton, true);
    }

    public static CopyTextPane createInstance(String theContentText, boolean showCopyButton) {
        return CopyTextPane.createInstance(theContentText, null, showCopyButton);
    }

    public static CopyTextPane createInstance(String theContentText) {
        return CopyTextPane.createInstance(theContentText, null, false);
    }

    private CopyTextPane(Labeled theContent, String theCopyButton, boolean showCopyButton) {
        Objects.requireNonNull(theContent, "Missing labeled object for output.");
        String sCopyButton = Objects.requireNonNullElse(theCopyButton, COPY_BUTTON);
        this.getChildren().add((Object)theContent);
        AnchorPane.setLeftAnchor((Node)theContent, (Double)0.0);
        AnchorPane.setRightAnchor((Node)theContent, (Double)50.0);
        if (showCopyButton) {
            Button btnCopyContent = new Button("", (Node)new ImageView(Resources.loadImage(sCopyButton, 16)));
            btnCopyContent.setOnAction(e -> CopyTextPane.copyText(theContent));
            btnCopyContent.setTooltip(new Tooltip("Text kopieren"));
            this.getChildren().add((Object)btnCopyContent);
            AnchorPane.setRightAnchor((Node)btnCopyContent, (Double)0.0);
            ContextMenu mnuContext = new ContextMenu();
            MenuItem itmCopy = new MenuItem("Text kopieren", (Node)new ImageView(Resources.loadImage(sCopyButton, 16)));
            itmCopy.setOnAction(e -> CopyTextPane.copyText(theContent));
            mnuContext.getItems().addAll((Object[])new MenuItem[]{itmCopy});
            theContent.setOnContextMenuRequested(e -> mnuContext.show((Node)e.getSource(), e.getScreenX(), e.getScreenY()));
        }
    }

    public static void copyText(Labeled theTextHolder) {
        ClipboardContent clpContent = new ClipboardContent();
        clpContent.putString(theTextHolder.getText());
        Clipboard.getSystemClipboard().setContent((Map)clpContent);
    }
}

