/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.javafx.controller;

import de.edgesoft.edgeutils.javafx.controller.CopyTextPane;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.layout.VBox;
import javax.naming.OperationNotSupportedException;

public abstract class AbstractHyperlinkController {
    private static boolean FOLLOW_LINKS = false;

    @FXML
    public void handleEmailLinkAction(ActionEvent theEvent) {
        if (FOLLOW_LINKS) {
            try {
                if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) {
                    throw new OperationNotSupportedException("Desktop does not support web links.");
                }
                Desktop.getDesktop().mail(new URI(String.format("mailto:%s", ((Hyperlink)theEvent.getTarget()).getText())));
            }
            catch (IOException | URISyntaxException | OperationNotSupportedException e) {
                e.printStackTrace();
            }
        } else {
            AbstractHyperlinkController.showSorry(((Hyperlink)theEvent.getTarget()).getText());
        }
    }

    @FXML
    public void handleWebLinkAction(ActionEvent theEvent) {
        if (FOLLOW_LINKS) {
            try {
                if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.APP_OPEN_URI)) {
                    throw new OperationNotSupportedException("Desktop does not support web links.");
                }
                Desktop.getDesktop().browse(new URI(((Hyperlink)theEvent.getTarget()).getText()));
            }
            catch (IOException | URISyntaxException | OperationNotSupportedException e) {
                e.printStackTrace();
            }
        } else {
            AbstractHyperlinkController.showSorry(((Hyperlink)theEvent.getTarget()).getText());
        }
    }

    private static void showSorry(String theLink) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.initOwner(null);
        alert.setResizable(true);
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alert.getDialogPane().setPrefWidth(400.0);
        alert.setTitle("\u00d6ffnen eines Links");
        alert.setHeaderText("Link kann nicht ge\u00f6ffnet werden");
        VBox boxContent = new VBox(5.0);
        Label lblSorry = new Label("Leider ist es nicht so einfach, einen Link zu \u00f6ffnen, daher kann ich nur anbieten, durch Anklicken des Buttons neben dem Link, diesen in die Zwischenablage zu kopieren.\nTut mir leid.");
        lblSorry.setWrapText(true);
        boxContent.getChildren().add((Object)lblSorry);
        boxContent.getChildren().add((Object)new Separator(Orientation.HORIZONTAL));
        boxContent.getChildren().add((Object)CopyTextPane.createInstance(theLink, true));
        alert.getDialogPane().setContent((Node)boxContent);
        alert.showAndWait();
    }
}

