/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.javafx;

import de.edgesoft.edgeutils.files.Resources;
import de.edgesoft.edgeutils.i18n.I18N;
import de.edgesoft.edgeutils.i18n.ResourceType;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.image.ImageView;

public class TableColumnUtils {
    public static final String PREFIX = "col";

    public static void fillTableColumn(TableColumn<?, ?> theTableColumn, Object theController, ResourceType ... theResourceTypes) {
        TableColumnUtils.fillTableColumn(theTableColumn, theController, -1, theResourceTypes);
    }

    public static void fillTableColumn(TableColumn<?, ?> theTableColumn, Object theController, int theSize, ResourceType ... theResourceTypes) {
        List<ResourceType> lstResourceTypes = theResourceTypes.length == 0 ? Arrays.asList(ResourceType.values()) : Arrays.asList(theResourceTypes);
        String sID = TableColumnUtils.removePrefix(theTableColumn.getId());
        if (lstResourceTypes.contains((Object)ResourceType.TEXT)) {
            I18N.getViewNodeText(theController, sID, ResourceType.TEXT, new Object[0]).ifPresent(it -> theTableColumn.setText(it));
        }
        if (lstResourceTypes.contains((Object)ResourceType.ICON)) {
            I18N.getViewNodeText(theController, sID, ResourceType.ICON, new Object[0]).ifPresent(it -> theTableColumn.setGraphic((Node)new ImageView(Resources.loadImage(it, theSize))));
        }
    }

    private static String removePrefix(String theID) {
        return theID.startsWith(PREFIX) ? theID.substring(PREFIX.length()) : theID;
    }

    public static void fillTableColumns(Object theController, ResourceType theResourceType, TableColumn<?, ?> ... theTableColumns) {
        Arrays.asList(theTableColumns).stream().forEach(it -> TableColumnUtils.fillTableColumn(it, theController, theResourceType));
    }
}

