/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.javafx;

import de.edgesoft.edgeutils.files.Resources;
import de.edgesoft.edgeutils.i18n.I18N;
import de.edgesoft.edgeutils.i18n.ResourceType;
import de.edgesoft.edgeutils.javafx.ControlUtils;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.image.ImageView;

public class TabUtils {
    public static final String PREFIX = "tab";

    public static void fillTab(Tab theTab, Object theController, ResourceType ... theResourceTypes) {
        TabUtils.fillTab(theTab, theController, -1, theResourceTypes);
    }

    public static void fillTab(Tab theTab, Object theController, int theSize, ResourceType ... theResourceTypes) {
        List<ResourceType> lstResourceTypes = theResourceTypes.length == 0 ? Arrays.asList(ResourceType.values()) : Arrays.asList(theResourceTypes);
        String sID = ControlUtils.removePrefix(theTab.getId(), PREFIX);
        if (lstResourceTypes.contains((Object)ResourceType.TEXT)) {
            I18N.getViewNodeText(theController, sID, ResourceType.TEXT, new Object[0]).ifPresent(it -> theTab.setText(it));
        }
        if (lstResourceTypes.contains((Object)ResourceType.ICON)) {
            I18N.getViewNodeText(theController, sID, ResourceType.ICON, new Object[0]).ifPresent(it -> theTab.setGraphic((Node)new ImageView(Resources.loadImage(it, theSize))));
        }
    }

    public static void fillTabs(Object theController, ResourceType theResourceType, Tab ... theTabs) {
        Arrays.asList(theTabs).stream().forEach(it -> TabUtils.fillTab(it, theController, theResourceType));
    }
}

