/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.javafx;

import java.awt.image.BufferedImage;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;

public class SVGImageTranscoder
extends ImageTranscoder {
    private static SVGImageTranscoder svgTranscoder = null;
    private BufferedImage bufImage = null;

    public void setWidth(int theWidth) {
        this.getTranscodingHints().remove((Object)SVGAbstractTranscoder.KEY_WIDTH);
        if (theWidth != -1) {
            this.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, Float.valueOf(theWidth));
        }
    }

    public void setHeight(int theHeight) {
        this.getTranscodingHints().remove((Object)SVGAbstractTranscoder.KEY_HEIGHT);
        if (theHeight != -1) {
            this.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, Float.valueOf(theHeight));
        }
    }

    public static SVGImageTranscoder createSVGImageTranscoder(int theWidth, int theHeight) {
        if (svgTranscoder == null) {
            svgTranscoder = new SVGImageTranscoder();
        }
        svgTranscoder.setWidth(theWidth);
        svgTranscoder.setHeight(theHeight);
        return svgTranscoder;
    }

    public BufferedImage createImage(int theWidth, int theHeight) {
        return new BufferedImage(theWidth, theHeight, 2);
    }

    public void writeImage(BufferedImage img, TranscoderOutput to) throws TranscoderException {
        this.bufImage = img;
    }

    public BufferedImage getBufferedImage() {
        return this.bufImage;
    }

    public Image getFXImage() {
        return SwingFXUtils.toFXImage((BufferedImage)this.getBufferedImage(), null);
    }
}

