/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.javafx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class KeyCodeCombinationUtils {
    public static List<KeyCodeCombination> getKeyCodeCombinations(String theText) {
        if (theText == null) {
            return Collections.emptyList();
        }
        ArrayList<KeyCodeCombination> lstReturn = new ArrayList<KeyCodeCombination>();
        for (char theChar : theText.toCharArray()) {
            lstReturn.add(KeyCodeCombinationUtils.getKeyCodeCombination(theChar));
        }
        return lstReturn;
    }

    public static KeyCodeCombination getKeyCodeCombination(char theChar) {
        KeyCode theKeyCode = null;
        switch (theChar) {
            case '-': {
                theKeyCode = KeyCode.MINUS;
                break;
            }
            case '.': {
                theKeyCode = KeyCode.PERIOD;
                break;
            }
            case ' ': {
                theKeyCode = KeyCode.SPACE;
                break;
            }
            case '_': {
                theKeyCode = KeyCode.UNDERSCORE;
                break;
            }
            case '@': {
                theKeyCode = KeyCode.AT;
                break;
            }
            default: {
                theKeyCode = KeyCode.getKeyCode((String)Character.toString(theChar).toUpperCase());
            }
        }
        if (Character.isAlphabetic(theChar) && Character.isUpperCase(theChar)) {
            return new KeyCodeCombination(theKeyCode, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN});
        }
        if (theKeyCode == KeyCode.AT) {
            return new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[0]);
        }
        return new KeyCodeCombination(theKeyCode, new KeyCombination.Modifier[0]);
    }
}

