/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.javafx;

import de.edgesoft.edgeutils.files.Resources;
import de.edgesoft.edgeutils.i18n.I18N;
import de.edgesoft.edgeutils.i18n.ResourceType;
import de.edgesoft.edgeutils.javafx.EdgeDatePicker;
import de.edgesoft.edgeutils.javafx.TimeTextField;
import de.edgesoft.edgeutils.javafx.TooltipUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.image.ImageView;
import org.apache.logging.log4j.util.Strings;

public class ControlUtils {
    public static final Map<Class<? extends Control>, String> PREFIXES = Map.of(Button.class, "btn", SplitMenuButton.class, "btn", CheckBox.class, "chk", Label.class, "lbl", DatePicker.class, "pck", EdgeDatePicker.class, "pck", RadioButton.class, "rad", TextField.class, "txt", TextInputControl.class, "txt", TimeTextField.class, "txt");

    public static void fillViewControl(Control theControl, Object theController, ResourceType ... theResourceTypes) {
        ControlUtils.fillViewControl(theControl, null, theController, theResourceTypes);
    }

    public static void fillViewControl(Control theControl, String theAdditionalId, Object theController, ResourceType ... theResourceTypes) {
        ControlUtils.fillViewControl(theControl, theAdditionalId, theController, -1, theResourceTypes);
    }

    public static void fillViewControl(Control theControl, Object theController, int theSize, ResourceType ... theResourceTypes) {
        ControlUtils.fillViewControl(theControl, null, theController, theSize, theResourceTypes);
    }

    public static void fillViewControl(Control theControl, String theAdditionalId, Object theController, int theSize, ResourceType ... theResourceTypes) {
        Objects.requireNonNull(theControl, "control must not be null.");
        List<ResourceType> lstResourceTypes = theResourceTypes.length == 0 ? Arrays.asList(ResourceType.values()) : Arrays.asList(theResourceTypes);
        String sID = ControlUtils.getIdWithoutPrefix(theControl, theAdditionalId);
        if (theControl instanceof Labeled) {
            if (lstResourceTypes.contains((Object)ResourceType.TEXT)) {
                I18N.getViewNodeText(theController, sID, ResourceType.TEXT, new Object[0]).ifPresent(it -> {
                    ((Labeled)theControl).setText(it);
                    ((Labeled)theControl).setMnemonicParsing(true);
                });
            }
            if (lstResourceTypes.contains((Object)ResourceType.ICON)) {
                I18N.getViewNodeText(theController, sID, ResourceType.ICON, new Object[0]).ifPresent(it -> ((Labeled)theControl).setGraphic((Node)new ImageView(Resources.loadImage(it, theSize))));
            }
        }
        if (theControl instanceof ButtonBase && (lstResourceTypes.contains((Object)ResourceType.TOOLTIP) || I18N.containsKey(I18N.getViewNodeKey(theController, sID, ResourceType.TEXT)))) {
            theControl.setTooltip(TooltipUtils.createTooltip(I18N.getViewNodeText(theController, sID, lstResourceTypes.contains((Object)ResourceType.TOOLTIP) ? ResourceType.TOOLTIP : ResourceType.TEXT, new Object[0]).get(), I18N.containsKey(I18N.getViewNodeKey(theController, sID, ResourceType.ACCELERATOR)) ? I18N.getViewNodeText(theController, sID, ResourceType.ACCELERATOR, new Object[0]).get() : null));
        }
        if (theControl instanceof ComboBoxBase && lstResourceTypes.contains((Object)ResourceType.PROMPTTEXT)) {
            I18N.getViewNodeText(theController, sID, ResourceType.PROMPTTEXT, new Object[0]).ifPresent(it -> ((ComboBoxBase)theControl).setPromptText(it));
        }
        if (theControl instanceof TextInputControl && lstResourceTypes.contains((Object)ResourceType.PROMPTTEXT)) {
            I18N.getViewNodeText(theController, sID, ResourceType.PROMPTTEXT, new Object[0]).ifPresent(it -> ((TextInputControl)theControl).setPromptText(it));
        }
    }

    public static String getIdWithoutPrefix(Control theControl) {
        return ControlUtils.getIdWithoutPrefix(theControl, null);
    }

    public static String getIdWithoutPrefix(Control theControl, String theAdditionalId) {
        Objects.requireNonNull(theControl, "control must not be null.");
        String sPrefix = PREFIXES.get(theControl.getClass());
        String sID = ControlUtils.removePrefix(theControl.getId(), sPrefix);
        if (Strings.isNotBlank((String)theAdditionalId)) {
            sID = String.join((CharSequence)".", sID, theAdditionalId);
        }
        return sID;
    }

    public static void fillViewControls(ResourceType theResourceType, Object theController, Control ... theControls) {
        Arrays.asList(theControls).stream().forEach(it -> ControlUtils.fillViewControl(it, theController, theResourceType));
    }

    public static String removePrefix(String theID, String thePrefix) {
        return theID.startsWith(thePrefix) ? theID.substring(thePrefix.length()) : theID;
    }
}

