/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.javafx;

import de.edgesoft.edgeutils.javafx.MenuItemUtils;
import de.edgesoft.edgeutils.javafx.TooltipUtils;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Labeled;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.image.ImageView;

public class ButtonUtils {
    public static void adaptButton(ButtonBase theButton, MenuItem theMenuItem) {
        if (theMenuItem.getGraphic() != null) {
            theButton.setGraphic((Node)new ImageView(((ImageView)theMenuItem.getGraphic()).getImage()));
        }
        theButton.setTooltip(TooltipUtils.createTooltip(theMenuItem.getText(), theMenuItem.getAccelerator()));
    }

    public static void adaptButtonWithAction(ButtonBase theButton, MenuItem theMenuItem) {
        ButtonUtils.adaptButton(theButton, theMenuItem);
        theButton.setOnAction(theMenuItem.getOnAction());
    }

    public static void bindDisable(ButtonBase theButton, ListView<?> theListView) {
        theButton.disableProperty().bind((ObservableValue)theListView.getSelectionModel().selectedItemProperty().isNull());
    }

    public static void bindDisable(ButtonBase theButton, ComboBox<?> theComboBox) {
        theButton.disableProperty().bind((ObservableValue)theComboBox.getSelectionModel().selectedItemProperty().isNull());
    }

    public static void bindDisable(ButtonBase theButton, Labeled theLabeled) {
        theButton.disableProperty().bind((ObservableValue)theLabeled.textProperty().isEmpty());
    }

    public static void fillSplitMenuButton(SplitMenuButton theSplitButton, MenuItem ... theMenuItems) {
        if (theMenuItems.length == 0) {
            return;
        }
        ButtonUtils.adaptButtonWithAction((ButtonBase)theSplitButton, theMenuItems[0]);
        if (theMenuItems.length > 1) {
            for (MenuItem menuItem : theMenuItems) {
                theSplitButton.getItems().add((Object)MenuItemUtils.copyMenuItem(menuItem));
            }
        }
    }
}

