/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.i18n;

import de.edgesoft.edgeutils.i18n.ResourcePrefix;
import de.edgesoft.edgeutils.i18n.ResourceType;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

public abstract class I18N {
    public static final String DELIMITER = ".";
    public static final String REFERENCE_PREFIX = "ref::";
    public static final String BUNDLE_NAME = "%s.resources.i18n.%sTexts";
    private static String sFilePath = null;
    private static String sRootPath = null;
    private static Optional<Logger> logger = null;
    private static ResourceBundle resBundle = null;

    public static void init(Class<?> theRootClass) {
        I18N.init(theRootClass, null, null);
    }

    public static void init(Class<?> theRootClass, Locale theLocale) {
        I18N.init(theRootClass, theLocale, null);
    }

    public static void init(Class<?> theRootClass, Locale theLocale, Logger theLogger) {
        assert (theRootClass != null) : "Root class must not be null.";
        sRootPath = theRootClass.getPackage().getName();
        sFilePath = String.format(BUNDLE_NAME, sRootPath, theRootClass.getSimpleName());
        I18N.setLocale(theLocale);
        logger = Optional.ofNullable(theLogger);
    }

    public static void setLocale(Locale theLocale) {
        Locale.setDefault(Objects.requireNonNullElse(theLocale, Locale.getDefault()));
    }

    private static ResourceBundle getResourceBundle() {
        assert (sFilePath != null) : "I18N file path must not be null";
        if (resBundle == null) {
            resBundle = ResourceBundle.getBundle(sFilePath, Locale.getDefault());
        }
        return resBundle;
    }

    public static boolean containsKey(String theKey) {
        return I18N.getResourceBundle().containsKey(theKey);
    }

    public static String createKey(String ... theKeyParts) {
        return String.join((CharSequence)DELIMITER, theKeyParts).toLowerCase();
    }

    public static Optional<String> getText(String theKey, Object ... theArguments) {
        if (I18N.containsKey(theKey)) {
            String sReturn = I18N.getResourceBundle().getString(theKey);
            if (sReturn.startsWith(REFERENCE_PREFIX)) {
                return I18N.getText(sReturn.substring(REFERENCE_PREFIX.length()), theArguments);
            }
            return Optional.ofNullable(MessageFormat.format(sReturn, theArguments));
        }
        logger.ifPresent(lgr -> lgr.debug(String.format("Missing resource for key '%s'", theKey)));
        return Optional.empty();
    }

    public static String getKey(Enum<?> theEnum) {
        return I18N.createKey(ResourcePrefix.ENUM.value(), theEnum.getClass().getPackageName(), theEnum.getClass().getSimpleName(), theEnum.name()).replace(String.format("%s.", sRootPath), "");
    }

    public static Optional<String> getText(Enum<?> theEnum, Object ... theArguments) {
        return I18N.getText(I18N.getKey(theEnum), theArguments);
    }

    public static String getViewNodeKey(Object theController, String theNodeID, ResourceType theResourceType) {
        return I18N.createKey(theController.getClass().getPackageName(), theController.getClass().getSimpleName(), theNodeID, theResourceType.value()).replace(".controller", ".view").replace("controller", "").replace(String.format("%s.", sRootPath), "");
    }

    public static Optional<String> getViewNodeText(Object theController, String theNodeID, ResourceType theResourceType, Object ... theArguments) {
        return I18N.getText(I18N.getViewNodeKey(theController, theNodeID, theResourceType), theArguments);
    }
}

