/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class TemplateHandler {
    private static final String PATH_TEMPLATES = String.format("%s/%s", "resources", "templates");
    private static Configuration tplConfig = null;

    public static Configuration getConfiguration() {
        if (tplConfig == null) {
            tplConfig = new Configuration(Configuration.VERSION_2_3_28);
            tplConfig.setDefaultEncoding(StandardCharsets.UTF_8.name());
            tplConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            tplConfig.setLogTemplateExceptions(false);
        }
        return tplConfig;
    }

    public static Template loadTemplate(Class<? extends Object> clsProvider, String theTemplateName) throws IOException {
        ClassTemplateLoader tplLoader = new ClassTemplateLoader(clsProvider, PATH_TEMPLATES);
        TemplateHandler.getConfiguration().setTemplateLoader((TemplateLoader)tplLoader);
        return TemplateHandler.getConfiguration().getTemplate(theTemplateName);
    }

    public static Template loadTemplate(String theTemplateName, File theTemplatePath) throws IOException {
        TemplateHandler.getConfiguration().setDirectoryForTemplateLoading(theTemplatePath);
        return TemplateHandler.getConfiguration().getTemplate(theTemplateName);
    }

    public static String processTemplate(Template theTemplate, Object theDataModel) throws TemplateException, IOException {
        String sReturn = null;
        try (StringWriter wrtContent = new StringWriter();){
            theTemplate.process(theDataModel, (Writer)wrtContent);
            sReturn = wrtContent.toString();
        }
        return sReturn;
    }

    public static String processStringTemplate(String theTemplateContent, Object theDataModel) throws TemplateException, IOException {
        return TemplateHandler.processTemplate(new Template(null, (Reader)new StringReader(theTemplateContent), TemplateHandler.getConfiguration()), theDataModel);
    }
}

