/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.files;

import de.edgesoft.edgeutils.javafx.SVGImageTranscoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.logging.log4j.Logger;

public class Resources {
    public static final String PATH_RESOURCES = "resources";
    public static final String PATH_VIEW = "view";
    public static final int USE_DEFAULT_SIZE = -1;
    private static Class<? extends Object> clsProvider = null;
    private static Logger logger = null;
    private static Optional<Double> dblScalingFactor = Optional.empty();
    private static Optional<Integer> iDefaultWidth = Optional.empty();
    private static Properties prpProject = null;

    public static void init(Class<? extends Object> theProvider, Logger theLogger) {
        clsProvider = theProvider;
        logger = theLogger;
    }

    public static void init(Class<? extends Object> theProvider, Logger theLogger, Double theScalingFactor, Integer theDefaultWidth) {
        Resources.init(theProvider, theLogger);
        Resources.setScalingFactor(theScalingFactor);
        Resources.setDefaultWidth(theDefaultWidth);
    }

    public static void setScalingFactor(Double theScalingFactor) {
        dblScalingFactor = Optional.of(theScalingFactor);
    }

    public static void setDefaultWidth(Integer theDefaultWidth) {
        iDefaultWidth = Optional.of(theDefaultWidth);
    }

    public static Double getScalingFactor() {
        return dblScalingFactor.orElse(1.0);
    }

    public static Integer getDefaultWidth() {
        return iDefaultWidth.orElse(24);
    }

    private static Class<? extends Object> getProvider() {
        assert (clsProvider != null) : "Providing class must not be null";
        return clsProvider;
    }

    public static Logger getLogger() {
        assert (logger != null) : "Logger must not be null";
        return logger;
    }

    public static Image loadImage(String theImagePath) {
        return Resources.loadImage(theImagePath, -1);
    }

    public static Image loadImage(String theImagePath, int theWidth) {
        return Resources.loadImage(theImagePath, theWidth, theWidth);
    }

    public static Image loadImage(String theImagePath, int theWidth, int theHeight) {
        Image imgReturn = null;
        if (theImagePath.endsWith(".svg")) {
            try (InputStream file = Resources.getProvider().getResourceAsStream(String.format("%s/%s", PATH_RESOURCES, theImagePath));){
                if (file == null) {
                    throw new FileNotFoundException(String.format("%s/%s", PATH_RESOURCES, theImagePath));
                }
                int iWidth = (int)Math.round((double)(theWidth > 0 ? theWidth : Resources.getDefaultWidth()) * Resources.getScalingFactor());
                int iHeight = (int)Math.round((double)(theHeight > 0 ? theHeight : Resources.getDefaultWidth()) * Resources.getScalingFactor());
                try {
                    SVGImageTranscoder trans = SVGImageTranscoder.createSVGImageTranscoder(iWidth, iHeight);
                    trans.transcode(new TranscoderInput(file), null);
                    imgReturn = trans.getFXImage();
                }
                catch (TranscoderException e) {
                    Resources.getLogger().catching((Throwable)e);
                }
            }
            catch (IOException e) {
                Resources.getLogger().catching((Throwable)e);
            }
        } else {
            imgReturn = new Image(Resources.getProvider().getResourceAsStream(String.format("%s/%s", PATH_RESOURCES, theImagePath)));
        }
        return imgReturn;
    }

    public static Map.Entry<Parent, FXMLLoader> loadNode(String theParentName) {
        Map.Entry<Object, FXMLLoader> fxmlObject = Resources.loadFXMLObject(theParentName);
        if (fxmlObject == null) {
            return null;
        }
        return new AbstractMap.SimpleImmutableEntry<Parent, FXMLLoader>((Parent)fxmlObject.getKey(), fxmlObject.getValue());
    }

    public static Map.Entry<Object, FXMLLoader> loadFXMLObject(String theFXMLName) {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(Resources.getProvider().getResource(String.format("%s/%s.fxml", PATH_VIEW, theFXMLName)));
            return new AbstractMap.SimpleImmutableEntry<Object, FXMLLoader>(loader.load(), loader);
        }
        catch (IOException e) {
            Resources.getLogger().catching((Throwable)e);
            return null;
        }
    }

    public static String loadFile(String theFileName) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(Resources.getProvider().getResourceAsStream(String.format("%s/%s", PATH_RESOURCES, theFileName))));
        try {
            StringBuilder sbReturn = new StringBuilder();
            String sLine = null;
            while ((sLine = reader.readLine()) != null) {
                sbReturn.append(sLine);
            }
            string = sbReturn.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Resources.getLogger().catching((Throwable)e);
                return "";
            }
        }
        reader.close();
        return string;
    }

    public static Properties getProjectProperties() {
        if (prpProject == null) {
            prpProject = Resources.loadProperties(String.format("%s/%s", PATH_RESOURCES, "project.properties"));
        }
        return prpProject;
    }

    public static Properties loadProperties(String theFileName) {
        Properties prpReturn = new Properties();
        try {
            prpReturn.load(Resources.getProvider().getResourceAsStream(theFileName));
        }
        catch (Exception e) {
            Resources.getLogger().catching((Throwable)e);
        }
        return prpReturn;
    }

    public static String getExternalURI(String theFileName) {
        return Resources.getProvider().getResource(theFileName).toExternalForm();
    }

    public static List<String> getSortedFileList(String theResourcePath, String theFileExtension) throws IOException {
        try {
            URL dirURL = Resources.getProvider().getResource(theResourcePath);
            if (dirURL == null) {
                throw new FileNotFoundException(String.format("resource not found: %s", theResourcePath));
            }
            Stream<Object> stmReturn = null;
            if (dirURL.getProtocol().equals("file")) {
                stmReturn = Arrays.asList(new File(dirURL.toURI()).list()).stream();
            }
            if (dirURL.getProtocol().equals("jar")) {
                String sJarPath = dirURL.getPath().substring("file:".length(), dirURL.getPath().indexOf("!"));
                String sResourcePath = dirURL.getPath().substring(dirURL.getPath().indexOf("!") + 2);
                try (JarFile jfJarFile = new JarFile(URLDecoder.decode(sJarPath, "UTF-8"));){
                    stmReturn = Collections.list(jfJarFile.entries()).stream().map(ZipEntry::getName).filter(filename -> filename.startsWith(sResourcePath)).map(filename -> filename.substring(sResourcePath.length()));
                }
            }
            if (stmReturn == null) {
                throw new IOException(String.format("Cannot list files for URL %s, because protocol %s is not supported.", dirURL, dirURL.getProtocol()));
            }
            return stmReturn.distinct().filter(filename -> theFileExtension == null ? true : filename.endsWith(theFileExtension)).sorted().collect(Collectors.toList());
        }
        catch (IOException | URISyntaxException e) {
            throw new IOException(e);
        }
    }
}

