/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.files;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileAccess {
    private static Charset theEncoding = StandardCharsets.UTF_8;

    public static void setEncoding(Charset newEncoding) {
        Objects.requireNonNull(newEncoding, "encoding must not be null");
        theEncoding = newEncoding;
    }

    public static Charset getEncoding() {
        return theEncoding;
    }

    public static String readFile(Path theFilePath) throws Exception {
        Objects.requireNonNull(theFilePath, "filename must not be null");
        String sReturn = null;
        try (Stream<String> stmLines = Files.lines(theFilePath, FileAccess.getEncoding());){
            sReturn = stmLines.collect(Collectors.joining(System.lineSeparator()));
        }
        return sReturn;
    }

    public static void writeFile(Path theFileName, String theContent) throws IOException {
        Objects.requireNonNull(theFileName, "filename must not be null");
        Objects.requireNonNull(theContent, "content must not be null");
        FileAccess.writeFile(theFileName, Arrays.asList(theContent));
    }

    public static void writeFile(Path theFileName, List<String> theContent) throws IOException {
        Objects.requireNonNull(theFileName, "filename must not be null");
        Objects.requireNonNull(theContent, "content must not be null");
        if (theFileName.getParent() != null) {
            Files.createDirectories(theFileName.getParent(), new FileAttribute[0]);
        }
        Files.write(theFileName, theContent, FileAccess.getEncoding(), new OpenOption[0]);
    }
}

