/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.xchart;

import de.edgesoft.edgeutils.xchart.BaseSeriesColors;
import de.edgesoft.edgeutils.xchart.BaseTheme;
import de.edgesoft.edgeutils.xchart.Colorschemes;
import java.awt.Color;
import java.util.Optional;
import org.knowm.xchart.CategoryChart;
import org.knowm.xchart.CategoryChartBuilder;
import org.knowm.xchart.CategorySeries;
import org.knowm.xchart.PieChart;
import org.knowm.xchart.PieChartBuilder;
import org.knowm.xchart.PieSeries;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.PieStyler;
import org.knowm.xchart.style.Theme;
import org.knowm.xchart.style.XYStyler;

public class ChartFactory {
    public static PieChart createPieChart(String theTitle, int theHeight, int theWidth, Optional<PieStyler.AnnotationType> theAnnotationType, Optional<Colorschemes> theColorscheme) {
        PieChart chart = ((PieChartBuilder)((PieChartBuilder)((PieChartBuilder)new PieChartBuilder().title(theTitle)).height(theHeight)).width(theWidth)).build();
        ((PieStyler)chart.getStyler()).setTheme((Theme)new BaseTheme());
        ((PieStyler)chart.getStyler()).setAnnotationType(theAnnotationType.orElse(PieStyler.AnnotationType.Value));
        ((PieStyler)chart.getStyler()).setLegendVisible(false);
        ((PieStyler)chart.getStyler()).setDefaultSeriesRenderStyle(PieSeries.PieSeriesRenderStyle.Donut);
        ((PieStyler)chart.getStyler()).setDonutThickness(0.45);
        ((PieStyler)chart.getStyler()).setAnnotationDistance(0.75);
        ((PieStyler)chart.getStyler()).setAnnotationsFont(((PieStyler)chart.getStyler()).getAnnotationsFont().deriveFont(1));
        ((PieStyler)chart.getStyler()).setChartFontColor(Color.DARK_GRAY);
        ((PieStyler)chart.getStyler()).setSeriesColors(new BaseSeriesColors().getSeriesColors(theColorscheme.orElse(Colorschemes.RdBu_diverging_9)));
        return chart;
    }

    public static XYChart createXYChart(String theTitle, int theHeight, int theWidth, Optional<Colorschemes> theColorscheme) {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().title(theTitle)).height(theHeight)).width(theWidth)).build();
        ((XYStyler)chart.getStyler()).setTheme((Theme)new BaseTheme());
        ((XYStyler)chart.getStyler()).setLegendVisible(false);
        ((XYStyler)chart.getStyler()).setChartFontColor(Color.DARK_GRAY);
        ((XYStyler)chart.getStyler()).setDatePattern("dd.MM.yyyy");
        ((XYStyler)chart.getStyler()).setDecimalPattern("#");
        ((XYStyler)chart.getStyler()).setPlotBorderVisible(false);
        ((XYStyler)chart.getStyler()).setPlotGridHorizontalLinesVisible(true);
        ((XYStyler)chart.getStyler()).setPlotGridVerticalLinesVisible(false);
        ((XYStyler)chart.getStyler()).setPlotTicksMarksVisible(false);
        ((XYStyler)chart.getStyler()).setXAxisTicksVisible(false);
        ((XYStyler)chart.getStyler()).setYAxisTickMarkSpacingHint(100);
        ((XYStyler)chart.getStyler()).setSeriesColors(new BaseSeriesColors().getSeriesColors(theColorscheme.orElse(Colorschemes.RdBu_diverging_9)));
        return chart;
    }

    public static CategoryChart createCategoryChart(String theTitle, int theHeight, int theWidth, Optional<CategorySeries.CategorySeriesRenderStyle> theCategorySeriesRenderStyle, Optional<Colorschemes> theColorscheme) {
        CategoryChart chart = ((CategoryChartBuilder)((CategoryChartBuilder)((CategoryChartBuilder)new CategoryChartBuilder().title(theTitle)).height(theHeight)).width(theWidth)).build();
        ((CategoryStyler)chart.getStyler()).setTheme((Theme)new BaseTheme());
        ((CategoryStyler)chart.getStyler()).setLegendVisible(false);
        ((CategoryStyler)chart.getStyler()).setChartFontColor(Color.DARK_GRAY);
        ((CategoryStyler)chart.getStyler()).setPlotGridVerticalLinesVisible(false);
        ((CategoryStyler)chart.getStyler()).setOverlapped(true);
        if (theCategorySeriesRenderStyle.isPresent()) {
            ((CategoryStyler)chart.getStyler()).setDefaultSeriesRenderStyle(theCategorySeriesRenderStyle.get());
        }
        ((CategoryStyler)chart.getStyler()).setDatePattern("dd.MM.yyyy");
        ((CategoryStyler)chart.getStyler()).setDecimalPattern("#");
        ((CategoryStyler)chart.getStyler()).setPlotBorderVisible(false);
        ((CategoryStyler)chart.getStyler()).setPlotGridHorizontalLinesVisible(true);
        ((CategoryStyler)chart.getStyler()).setPlotGridVerticalLinesVisible(false);
        ((CategoryStyler)chart.getStyler()).setPlotTicksMarksVisible(false);
        ((CategoryStyler)chart.getStyler()).setXAxisTicksVisible(false);
        ((CategoryStyler)chart.getStyler()).setYAxisTickMarkSpacingHint(100);
        ((CategoryStyler)chart.getStyler()).setSeriesColors(new BaseSeriesColors().getSeriesColors(theColorscheme.orElse(Colorschemes.RdBu_diverging_9)));
        return chart;
    }
}

