/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.xchart;

import de.edgesoft.edgeutils.xchart.BaseSeriesColors;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Stroke;
import org.knowm.xchart.style.AbstractBaseTheme;
import org.knowm.xchart.style.PieStyler;
import org.knowm.xchart.style.colors.ChartColor;

public class BaseTheme
extends AbstractBaseTheme {
    private static final String FONTNAME = "Droid Sans";

    public Font getBaseFont() {
        return new Font(BaseTheme.getFontName(), 0, 10);
    }

    public Color[] getSeriesColors() {
        return new BaseSeriesColors().getSeriesColors();
    }

    public boolean isChartTitleBoxVisible() {
        return false;
    }

    public Font getAxisTitleFont() {
        return this.getBaseFont().deriveFont(12.0f);
    }

    public boolean isAxisTicksLineVisible() {
        return false;
    }

    public boolean isAxisTicksMarksVisible() {
        return false;
    }

    public Color getPlotBorderColor() {
        return ChartColor.getAWTColor((ChartColor)ChartColor.BLACK);
    }

    public boolean isPlotBorderVisible() {
        return false;
    }

    public Color getPlotGridLinesColor() {
        return ChartColor.getAWTColor((ChartColor)ChartColor.BLACK);
    }

    public Stroke getPlotGridLinesStroke() {
        return new BasicStroke(0.25f, 0, 1, 10.0f, new float[]{1.0f, 2.0f}, 0.0f);
    }

    public double getPlotContentSize() {
        return 0.9;
    }

    public double getAnnotationDistance() {
        return 0.82;
    }

    public PieStyler.AnnotationType getAnnotationType() {
        return PieStyler.AnnotationType.Value;
    }

    public boolean isSumVisible() {
        return true;
    }

    public static String getFontName() {
        for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            if (!FONTNAME.equalsIgnoreCase(font.getFontName())) continue;
            return FONTNAME;
        }
        return "SansSerif";
    }
}

