/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.jaxb;

import de.edgesoft.edgeutils.EdgeUtilsException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Objects;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JAXBFiles {
    private static Charset theEncoding = StandardCharsets.UTF_8;

    public static void setEncoding(Charset newEncoding) {
        Objects.requireNonNull(newEncoding, "encoding must not be null");
        theEncoding = newEncoding;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(String theFileName, Class<T> theClass) throws EdgeUtilsException {
        Objects.requireNonNull(theFileName, "file name must not be null");
        Objects.requireNonNull(theClass, "class must not be null");
        try (FileInputStream stmXML = new FileInputStream(theFileName);){
            if (theFileName.isEmpty()) {
                T t = null;
                return t;
            }
            Unmarshaller u = JAXBContext.newInstance((String)theClass.getPackage().getName()).createUnmarshaller();
            JAXBElement doc = (JAXBElement)u.unmarshal((InputStream)stmXML);
            Object object = doc.getValue();
            return (T)object;
        }
        catch (IOException | JAXBException e) {
            throw new EdgeUtilsException(MessageFormat.format("Error reading data: {0}", e.getMessage()));
        }
    }

    public static <T> T unmarshalInclude(String theFileName, Class<T> theClass) throws EdgeUtilsException {
        Objects.requireNonNull(theFileName, "file name must not be null");
        Objects.requireNonNull(theClass, "class must not be null");
        try {
            if (theFileName.isEmpty()) {
                return null;
            }
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setXIncludeAware(true);
            spf.setNamespaceAware(true);
            XMLReader xr = spf.newSAXParser().getXMLReader();
            SAXSource src = new SAXSource(xr, new InputSource(theFileName));
            return (T)JAXB.unmarshal((Source)src, theClass);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new EdgeUtilsException(MessageFormat.format("Error reading data: {0}", e.getMessage()));
        }
    }

    public static <T> T unmarshal(Reader theReader, Class<T> theClass) throws EdgeUtilsException {
        Objects.requireNonNull(theReader, "reader must not be null");
        Objects.requireNonNull(theClass, "class must not be null");
        try {
            Unmarshaller u = JAXBContext.newInstance((String)theClass.getPackage().getName()).createUnmarshaller();
            JAXBElement doc = (JAXBElement)u.unmarshal(theReader);
            return (T)doc.getValue();
        }
        catch (JAXBException e) {
            throw new EdgeUtilsException(MessageFormat.format("Error reading data: {0}", e.getMessage()));
        }
    }

    public static <T> void marshal(JAXBElement<T> theDataElement, String theFileName, String theSchema) throws EdgeUtilsException {
        Objects.requireNonNull(theDataElement, "data element must not be null");
        Objects.requireNonNull(theFileName, "file name must not be null");
        try (FileOutputStream stmOut = new FileOutputStream(theFileName);){
            Marshaller m = JAXBContext.newInstance((String)theDataElement.getDeclaredType().getPackage().getName()).createMarshaller();
            m.setProperty("jaxb.encoding", (Object)theEncoding.name());
            m.setProperty("jaxb.formatted.output", (Object)true);
            if (theSchema != null) {
                m.setProperty("jaxb.noNamespaceSchemaLocation", (Object)theSchema);
            }
            m.marshal(theDataElement, (OutputStream)stmOut);
        }
        catch (IOException | JAXBException e) {
            throw new EdgeUtilsException(MessageFormat.format("Error writing data: {0}", e.getMessage()));
        }
    }

    public static <T> String marshalToString(JAXBElement<T> theDataElement, String theSchema) throws EdgeUtilsException {
        Objects.requireNonNull(theDataElement, "data element must not be null");
        try {
            Marshaller m = JAXBContext.newInstance((String)theDataElement.getDeclaredType().getPackage().getName()).createMarshaller();
            m.setProperty("jaxb.encoding", (Object)theEncoding.name());
            m.setProperty("jaxb.formatted.output", (Object)true);
            if (theSchema != null) {
                m.setProperty("jaxb.noNamespaceSchemaLocation", (Object)theSchema);
            }
            StringWriter sWriter = new StringWriter();
            m.marshal(theDataElement, (Writer)sWriter);
            return sWriter.toString();
        }
        catch (JAXBException e) {
            throw new EdgeUtilsException(MessageFormat.format("Error writing data: {0}", e.getMessage()));
        }
    }
}

