/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.javafx;

import de.edgesoft.edgeutils.files.Resources;
import de.edgesoft.edgeutils.i18n.I18N;
import de.edgesoft.edgeutils.i18n.ResourceType;
import de.edgesoft.edgeutils.javafx.ControlUtils;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCombination;

public class MenuItemUtils {
    public static final String PREFIX = "mnu";

    public static MenuItem copyMenuItem(MenuItem theMenuItem) {
        MenuItem mnuReturn = new MenuItem();
        if (theMenuItem.getText() != null) {
            mnuReturn.setText(theMenuItem.getText());
        }
        if (theMenuItem.getGraphic() != null) {
            mnuReturn.setGraphic((Node)new ImageView(((ImageView)theMenuItem.getGraphic()).getImage()));
        }
        if (theMenuItem.getAccelerator() != null) {
            mnuReturn.setAccelerator(theMenuItem.getAccelerator());
        }
        if (theMenuItem.getOnAction() != null) {
            mnuReturn.setOnAction(theMenuItem.getOnAction());
        }
        return mnuReturn;
    }

    public static void fillMenuItem(MenuItem theMenuItem, Object theController, ResourceType ... theResourceTypes) {
        MenuItemUtils.fillMenuItem(theMenuItem, theController, -1, theResourceTypes);
    }

    public static void fillMenuItem(MenuItem theMenuItem, Object theController, int theSize, ResourceType ... theResourceTypes) {
        List<ResourceType> lstResourceTypes = theResourceTypes.length == 0 ? Arrays.asList(ResourceType.values()) : Arrays.asList(theResourceTypes);
        String sID = ControlUtils.removePrefix(theMenuItem.getId(), PREFIX);
        if (lstResourceTypes.contains((Object)ResourceType.TEXT)) {
            I18N.getViewNodeText(theController, sID, ResourceType.TEXT, new Object[0]).ifPresent(it -> theMenuItem.setText(it));
        }
        if (lstResourceTypes.contains((Object)ResourceType.ICON)) {
            I18N.getViewNodeText(theController, sID, ResourceType.ICON, new Object[0]).ifPresent(it -> theMenuItem.setGraphic((Node)new ImageView(Resources.loadImage(it, theSize))));
        }
        if (lstResourceTypes.contains((Object)ResourceType.ACCELERATOR)) {
            I18N.getViewNodeText(theController, sID, ResourceType.ACCELERATOR, new Object[0]).ifPresent(it -> theMenuItem.setAccelerator(KeyCombination.keyCombination((String)it)));
        }
    }
}

