/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.files;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public class Prefs {
    public static final int SIZE_BUTTON = 24;
    public static final int SIZE_BUTTON_SMALL = 16;
    public static final int SIZE_ALERT = 48;
    public static final int SIZE_FLAG = 20;
    private static Preferences preferences = null;

    public static void init(Class<? extends Object> theProvider) {
        if (preferences == null) {
            preferences = Preferences.userNodeForPackage(theProvider);
        }
    }

    public static Preferences getPrefs() {
        assert (preferences != null) : "Prefs were not initialized.";
        return preferences;
    }

    public static void put(String theKey, String theValue) {
        Prefs.getPrefs().put(theKey, theValue);
    }

    public static String get(String theKey) {
        return Prefs.get(theKey, "");
    }

    public static String get(String theKey, String theDefault) {
        return Prefs.getPrefs().get(theKey, theDefault);
    }

    public static void exportPrefs(OutputStream theStream) throws IOException, BackingStoreException {
        Prefs.getPrefs().exportNode(theStream);
    }

    public static void importPrefs(InputStream theStream) throws IOException, InvalidPreferencesFormatException, BackingStoreException {
        Prefs.getPrefs().clear();
        Preferences.importPreferences(theStream);
    }

    public static Map<String, Object> getPrefsMap() throws BackingStoreException {
        HashMap<String, Object> mapReturn = new HashMap<String, Object>();
        for (String theKey : Prefs.getPrefs().keys()) {
            mapReturn.put(theKey, Prefs.get(theKey));
        }
        return mapReturn;
    }
}

