/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.datetime;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.util.StringConverter;

public class DateTimeUtils {
    public static final String DATE_PATTERN = "dd.MM.yyyy";
    public static final String TIME_PATTERN = "HH:mm";
    public static final String DATETIME_PATTERN = String.format("%s, %s", "dd.MM.yyyy", "HH:mm");
    private static final Map<Class<? extends TemporalAccessor>, DateTimeFormatter> STANDARD_FORMATTERS = Collections.unmodifiableMap(new HashMap<Class<? extends TemporalAccessor>, DateTimeFormatter>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(LocalDate.class, DateTimeFormatter.ofPattern(DateTimeUtils.DATE_PATTERN));
            this.put(LocalTime.class, DateTimeFormatter.ofPattern(DateTimeUtils.TIME_PATTERN));
            this.put(LocalDateTime.class, DateTimeFormatter.ofPattern(DATETIME_PATTERN));
        }
    });

    private static DateTimeFormatter getFormatter(String thePattern) {
        return thePattern == null ? null : DateTimeFormatter.ofPattern(thePattern);
    }

    public static String formatTemporalAccessor(TemporalAccessor theAccessor) {
        return DateTimeUtils.formatTemporalAccessor(theAccessor, DateTimeUtils.getFormatter(null));
    }

    public static String formatTemporalAccessor(TemporalAccessor theAccessor, String thePattern) {
        return DateTimeUtils.formatTemporalAccessor(theAccessor, DateTimeUtils.getFormatter(thePattern));
    }

    public static String formatTemporalAccessor(TemporalAccessor theAccessor, DateTimeFormatter theFormatter) {
        if (theAccessor == null) {
            return null;
        }
        DateTimeFormatter fmtFormatter = theFormatter;
        if (fmtFormatter == null) {
            fmtFormatter = STANDARD_FORMATTERS.get(theAccessor.getClass());
        }
        if (fmtFormatter == null) {
            return null;
        }
        return fmtFormatter.format(theAccessor);
    }

    public static String formatDate(LocalDate theDate) {
        return DateTimeUtils.formatDate(theDate, DateTimeUtils.getFormatter(null));
    }

    public static String formatDate(LocalDate theDate, String thePattern) {
        return DateTimeUtils.formatDate(theDate, DateTimeUtils.getFormatter(thePattern));
    }

    public static String formatDate(LocalDate theDate, DateTimeFormatter theFormatter) {
        return DateTimeUtils.formatTemporalAccessor((TemporalAccessor)theDate, theFormatter);
    }

    public static String formatDateTime(LocalDateTime theDateTime) {
        return DateTimeUtils.formatDateTime(theDateTime, DateTimeUtils.getFormatter(null));
    }

    public static String formatDateTime(LocalDateTime theDateTime, String thePattern) {
        return DateTimeUtils.formatDateTime(theDateTime, DateTimeUtils.getFormatter(thePattern));
    }

    public static String formatDateTime(LocalDateTime theDateTime, DateTimeFormatter theFormatter) {
        return DateTimeUtils.formatTemporalAccessor((TemporalAccessor)theDateTime, theFormatter);
    }

    public static String formatTime(LocalTime theTime) {
        return DateTimeUtils.formatTime(theTime, DateTimeUtils.getFormatter(null));
    }

    public static String formatTime(LocalTime theTime, String thePattern) {
        return DateTimeUtils.formatTime(theTime, DateTimeUtils.getFormatter(thePattern));
    }

    public static String formatTime(LocalTime theTime, DateTimeFormatter theFormatter) {
        return DateTimeUtils.formatTemporalAccessor((TemporalAccessor)theTime, theFormatter);
    }

    public static String formatDateTimeAsDate(LocalDateTime theDateTime) {
        return theDateTime == null ? null : DateTimeUtils.formatDate(theDateTime.toLocalDate());
    }

    public static String formatDateTimeAsTime(LocalDateTime theDateTime) {
        return theDateTime == null ? null : DateTimeUtils.formatTime(theDateTime.toLocalTime());
    }

    public static LocalDate parseDate(String theString) {
        return DateTimeUtils.parseDate(theString, DateTimeUtils.getFormatter(null));
    }

    public static LocalDate parseDate(String theString, String thePattern) {
        return DateTimeUtils.parseDate(theString, DateTimeUtils.getFormatter(thePattern));
    }

    public static LocalDate parseDate(String theString, DateTimeFormatter theFormatter) {
        if (theString == null) {
            return null;
        }
        try {
            return LocalDate.parse(theString, theFormatter == null ? STANDARD_FORMATTERS.get(LocalDate.class) : theFormatter);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public static boolean isValidDate(String theString) {
        return DateTimeUtils.isValidDate(theString, DateTimeUtils.getFormatter(null));
    }

    public static boolean isValidDate(String theString, String thePattern) {
        return DateTimeUtils.isValidDate(theString, DateTimeUtils.getFormatter(thePattern));
    }

    public static boolean isValidDate(String theString, DateTimeFormatter theFormatter) {
        return DateTimeUtils.parseDate(theString, theFormatter) != null;
    }

    public static LocalTime parseTime(String theString) {
        return DateTimeUtils.parseTime(theString, DateTimeUtils.getFormatter(null));
    }

    public static LocalTime parseTime(String theString, String thePattern) {
        return DateTimeUtils.parseTime(theString, DateTimeUtils.getFormatter(thePattern));
    }

    public static LocalTime parseTime(String theString, DateTimeFormatter theFormatter) {
        if (theString == null) {
            return null;
        }
        try {
            return LocalTime.parse(theString, theFormatter == null ? STANDARD_FORMATTERS.get(LocalTime.class) : theFormatter);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public static boolean isValidTime(String theString) {
        return DateTimeUtils.isValidTime(theString, DateTimeUtils.getFormatter(null));
    }

    public static boolean isValidTime(String theString, String thePattern) {
        return DateTimeUtils.isValidTime(theString, DateTimeUtils.getFormatter(thePattern));
    }

    public static boolean isValidTime(String theString, DateTimeFormatter theFormatter) {
        return DateTimeUtils.parseTime(theString, theFormatter) != null;
    }

    public static LocalDateTime parseDateTime(String theString) {
        return DateTimeUtils.parseDateTime(theString, DateTimeUtils.getFormatter(null));
    }

    public static LocalDateTime parseDateTime(String theString, String thePattern) {
        return DateTimeUtils.parseDateTime(theString, DateTimeUtils.getFormatter(thePattern));
    }

    public static LocalDateTime parseDateTime(String theString, DateTimeFormatter theFormatter) {
        if (theString == null) {
            return null;
        }
        if (theFormatter != null) {
            try {
                return LocalDateTime.parse(theString, theFormatter);
            }
            catch (DateTimeParseException e) {
                return null;
            }
        }
        List<DateTimeFormatter> lstFormatters = Arrays.asList(STANDARD_FORMATTERS.get(LocalDateTime.class), new DateTimeFormatterBuilder().appendPattern(String.format("%s[, %s]", DATE_PATTERN, TIME_PATTERN)).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter(), new DateTimeFormatterBuilder().appendPattern(String.format("[%s, ]%s", DATE_PATTERN, TIME_PATTERN)).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.YEAR, 2000L).toFormatter(), DateTimeFormatter.ISO_LOCAL_DATE_TIME, DateTimeFormatter.ofPattern("d.M.yyyy HH:mm:ss"), new DateTimeFormatterBuilder().appendPattern("d.M.yyyy[ HH:mm:ss]").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter(), new DateTimeFormatterBuilder().appendPattern("[d.M.yyyy ]HH:mm:ss").parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.YEAR, 2000L).toFormatter(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        for (DateTimeFormatter fmtFormatter : lstFormatters) {
            try {
                return LocalDateTime.parse(theString, fmtFormatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    public static Date toDate(LocalDateTime theDateTime) {
        return Date.from(theDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDate theDate) {
        return Date.from(theDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static StringConverter<LocalDate> getDateConverter() {
        return DateTimeUtils.getDateConverter(DateTimeUtils.getFormatter(null));
    }

    public static StringConverter<LocalDate> getDateConverter(String thePattern) {
        return DateTimeUtils.getDateConverter(DateTimeUtils.getFormatter(thePattern));
    }

    public static StringConverter<LocalDate> getDateConverter(final DateTimeFormatter theFormatter) {
        return new StringConverter<LocalDate>(){

            public String toString(LocalDate date) {
                if (date == null) {
                    return "";
                }
                return DateTimeUtils.formatDate(date, theFormatter);
            }

            public LocalDate fromString(String string) {
                return DateTimeUtils.parseDate(string, theFormatter);
            }
        };
    }
}

