/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.commandline;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public abstract class AbstractMainClass {
    private Options optOptions = null;
    private CommandLine cliCommandLine = null;
    private String sDescription = null;

    public abstract void executeOperation(String[] var1);

    public void init(String[] args) {
        try {
            this.cliCommandLine = new DefaultParser().parse(this.getOptions(), args);
        }
        catch (Exception e) {
            System.err.println(this.getUsage(e));
            System.exit(1);
        }
    }

    public void addOption(String theShortName, String theLongName, String theDescription, boolean hasArgument, boolean isRequired) {
        this.getOptions().addOption(Option.builder((String)theShortName).longOpt(theLongName).desc(theDescription).hasArg(hasArgument).required(isRequired).build());
    }

    public Options getOptions() {
        if (this.optOptions == null) {
            this.optOptions = new Options();
        }
        return this.optOptions;
    }

    public String getOptionValue(String theShortName) {
        return this.cliCommandLine.getOptionValue(theShortName);
    }

    public boolean hasOption(String theShortName) {
        return this.cliCommandLine.hasOption(theShortName);
    }

    public String getDescription() {
        return this.sDescription == null ? "" : this.sDescription;
    }

    public void setDescription(String theDescription) {
        this.sDescription = theDescription;
    }

    public String getUsage() {
        return this.getUsage(null);
    }

    public String getUsage(Exception e) {
        HelpFormatter hFormatter = new HelpFormatter();
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter(sWriter);
        hFormatter.printHelp(pWriter, hFormatter.getWidth(), this.getClass().getSimpleName(), this.getDescription(), this.getOptions(), hFormatter.getLeftPadding(), hFormatter.getDescPadding(), e == null ? "" : e.getMessage(), true);
        pWriter.flush();
        return sWriter.toString();
    }
}

