/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CollectionHelper {
    public static <T> String toCSVString(Collection<T> theCollection, String theSeparator) {
        if (theCollection == null || theSeparator == null) {
            return "";
        }
        StringBuffer sbReturn = new StringBuffer();
        boolean isFurther = false;
        for (T theElement : theCollection) {
            if (isFurther) {
                sbReturn.append(theSeparator);
            }
            if (theElement == null) {
                sbReturn.append(theElement);
            } else {
                sbReturn.append(theElement.toString().trim());
            }
            isFurther = true;
        }
        return sbReturn.toString();
    }

    public static List<String> fromCSVString(String theLine, String theSeparator) {
        List<String> lstReturn = CollectionHelper.trimSplit(theLine, theSeparator);
        if (lstReturn == null) {
            return null;
        }
        if (theSeparator.length() == 1) {
            int iSepCount = CollectionHelper.countOccurrences(theLine, theSeparator.charAt(0));
            for (int i = lstReturn.size(); i <= iSepCount; ++i) {
                lstReturn.add("");
            }
        }
        return lstReturn;
    }

    public static List<String> trimSplit(String theLine, String theSeparator) {
        String sSeparator;
        if (theLine == null || theSeparator == null) {
            return null;
        }
        ArrayList<String> lstReturn = new ArrayList<String>();
        String string = sSeparator = theSeparator.equals(".") ? "\\." : theSeparator;
        if (theLine.trim().isEmpty()) {
            return lstReturn;
        }
        for (String theEntry : Arrays.asList(theLine.trim().split(sSeparator))) {
            lstReturn.add(theEntry.trim());
        }
        return lstReturn;
    }

    public static int countOccurrences(String haystack, char needle) {
        if (haystack == null) {
            return -1;
        }
        int iCount = 0;
        for (char c : haystack.toCharArray()) {
            if (c != needle) continue;
            ++iCount;
        }
        return iCount;
    }

    public static <T> boolean isEmptyString(Collection<T> theCollection) {
        if (theCollection == null) {
            return false;
        }
        boolean bReturn = true;
        for (T theObject : theCollection) {
            if (theObject.toString().isEmpty()) continue;
            bReturn = false;
        }
        return bReturn;
    }

    public static <T> List<T> getFilledList(T theValue, int theSize) {
        if (theValue == null) {
            return null;
        }
        if (theSize < 0) {
            return Collections.emptyList();
        }
        ArrayList<T> lstReturn = new ArrayList<T>();
        for (int i = 0; i < theSize; ++i) {
            lstReturn.add(theValue);
        }
        return lstReturn;
    }
}

