/*
 * Decompiled with CFR 0.152.
 */
package de.ecclesia.kipeto.bootstrap;

import de.ecclesia.kipeto.bootstrap.IUpdateStrategy;
import de.ecclesia.kipeto.common.util.Streams;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUpdateStrategy
implements IUpdateStrategy {
    private static final Logger log = LoggerFactory.getLogger(HttpUpdateStrategy.class);
    private String jarUrl;
    private CloseableHttpClient client;
    private long contentLength;

    public HttpUpdateStrategy(String repositoryUrl) {
        this.jarUrl = String.format("%s/%s/%s", repositoryUrl, "dist", "kipeto.jar");
        this.client = HttpClients.createDefault();
    }

    public String getUpdateUrl() {
        return this.jarUrl;
    }

    public long getUpdateSize() {
        return this.contentLength;
    }

    public Date downloadUpdate(OutputStream destinationStream) throws Exception {
        HttpGet httpget = new HttpGet();
        CloseableHttpResponse contentResponse = this.client.execute((HttpUriRequest)httpget);
        HttpEntity entity = contentResponse.getEntity();
        Header lastModifiedHeader = contentResponse.getFirstHeader("Last-Modified");
        Date lastModified = DateUtils.parseDate((String)lastModifiedHeader.getValue());
        int statusCode = contentResponse.getStatusLine().getStatusCode();
        log.debug("HttpGet at {}, Status is {}", (Object)this.jarUrl, (Object)statusCode);
        if (statusCode != 200) {
            throw new RuntimeException(contentResponse.getStatusLine().toString());
        }
        Streams.copyStream((InputStream)entity.getContent(), (OutputStream)destinationStream, (boolean)true);
        contentResponse.close();
        return lastModified;
    }

    public boolean isUpdateAvailable(File localJarFile) throws Exception {
        HttpHead httpHead = new HttpHead(this.jarUrl);
        CloseableHttpResponse headResponse = this.client.execute((HttpUriRequest)httpHead);
        int statusCode = headResponse.getStatusLine().getStatusCode();
        log.debug("HttpHead at {}, Status is {}", (Object)this.jarUrl, (Object)statusCode);
        if (statusCode != 200) {
            throw new RuntimeException(headResponse.getStatusLine().toString());
        }
        Header lastModifiedHeader = headResponse.getFirstHeader("Last-Modified");
        Date lastModified = DateUtils.parseDate((String)lastModifiedHeader.getValue());
        log.debug("HttpHead {} - Last-Modified: {}", (Object)this.jarUrl, (Object)lastModified);
        Header contentLengthHeader = headResponse.getFirstHeader("Content-Length");
        this.contentLength = Long.parseLong(contentLengthHeader.getValue());
        log.debug("HttpHead {} - Content-Length: {}", (Object)this.jarUrl, (Object)this.contentLength);
        log.debug("Local Kipeto Jar {} - Last-Modified: {}", (Object)localJarFile, (Object)new Date(localJarFile.lastModified()));
        log.debug("Local Kipeto Jar {} - Content-Length: {}", (Object)localJarFile, (Object)localJarFile.length());
        headResponse.close();
        return !localJarFile.exists() || lastModified.getTime() != localJarFile.lastModified() || this.contentLength != localJarFile.length();
    }
}

