/*
 * Decompiled with CFR 0.152.
 */
package de.ecclesia.kipeto.bootstrap;

import de.ecclesia.kipeto.bootstrap.BootOptions;
import de.ecclesia.kipeto.bootstrap.BootstrapWindow;
import de.ecclesia.kipeto.bootstrap.FileUpdateStrategy;
import de.ecclesia.kipeto.bootstrap.HttpUpdateStrategy;
import de.ecclesia.kipeto.bootstrap.IUpdateStrategy;
import de.ecclesia.kipeto.common.AWTExceptionErrorDialog;
import de.ecclesia.kipeto.common.util.ByteTransferEvent;
import de.ecclesia.kipeto.common.util.ByteTransferListener;
import de.ecclesia.kipeto.common.util.CountingOutputStream;
import de.ecclesia.kipeto.common.util.FileSizeFormatter;
import de.ecclesia.kipeto.common.util.LoggerConfigurer;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import javax.swing.JFrame;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapApp {
    public static final String TEMP_DIR = "temp";
    public static final String JAR_FILENAME = "kipeto.jar";
    public static final String DIST_DIR = "dist";
    private static final long MS_TO_WAIT_UNTIL_WINDOW = 1500L;
    private static final String KIPETO_CLASS = "de.ecclesia.kipeto.KipetoApp";
    private final Logger logger = LoggerFactory.getLogger(BootstrapApp.class);
    private final String[] args;
    private final BootOptions options;
    private File tempDir;
    private File jar;
    private BootstrapWindow window;
    private long updateLength;
    private FileAppender appender;
    private IUpdateStrategy updateStrategy;

    public static void main(String[] args) throws Exception {
        BootstrapApp bootstrapper = new BootstrapApp(args);
        if (!bootstrapper.options.noSelfUpdate()) {
            try {
                bootstrapper.checkForUpdate();
            }
            catch (Exception e) {
                bootstrapper.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        try {
            bootstrapper.launchKipeto();
        }
        catch (Exception e) {
            bootstrapper.logger.error(e.getMessage(), (Throwable)e);
            if (bootstrapper.options.isGui()) {
                AWTExceptionErrorDialog errorDialog = new AWTExceptionErrorDialog((Frame)new JFrame(), e);
                errorDialog.setVisible(true);
            }
            e.printStackTrace();
        }
        System.exit(0);
    }

    private void launchKipeto() throws Exception {
        this.logger.debug("Launching {}", (Object)this.jar);
        if (!this.jar.exists()) {
            throw new FileNotFoundException("File not found: " + this.jar.getAbsolutePath());
        }
        URL[] urls = new URL[]{new URL("file:" + this.jar.getAbsolutePath())};
        ClassLoader bootstrapClassLoader = ClassLoader.getSystemClassLoader().getParent();
        URLClassLoader classLoader = new URLClassLoader(urls, bootstrapClassLoader);
        Class<?> loadClass = classLoader.loadClass(KIPETO_CLASS);
        Method method = loadClass.getMethod("main", String[].class);
        org.apache.log4j.Logger.getRootLogger().removeAppender((Appender)this.appender);
        method.invoke(null, new Object[]{this.args});
        org.apache.log4j.Logger.getRootLogger().addAppender((Appender)this.appender);
        classLoader.close();
    }

    public BootstrapApp(String[] args) throws FileNotFoundException {
        this.args = args;
        this.options = new BootOptions(args);
        this.appender = LoggerConfigurer.configureFileAppender((String)this.options.getData(), (String)"bootstrapper");
        LoggerConfigurer.configureConsoleAppender((Level)Level.toLevel((String)this.options.getLogLevel(), (Level)Level.INFO));
        this.logger.debug("Options: {}", (Object)this.options);
        File rootDir = new File(BootstrapApp.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParentFile();
        this.logger.debug("RootDir: {}", (Object)rootDir);
        File data = new File(this.options.getData());
        this.logger.debug("DataDir: {}", (Object)data);
        this.tempDir = new File(data, TEMP_DIR);
        this.logger.debug("TempDir: {}", (Object)this.tempDir);
        this.jar = new File(data, JAR_FILENAME);
        this.logger.debug("Kipeto-Jar: {}", (Object)this.jar);
        this.tempDir.mkdirs();
    }

    private void checkForUpdate() throws Exception {
        File localRepositoryFile = new File(this.options.getRepositoryUrl());
        if (this.options.getRepositoryUrl().toLowerCase().startsWith("http")) {
            this.updateStrategy = new HttpUpdateStrategy(this.options.getRepositoryUrl());
        } else if (localRepositoryFile.exists()) {
            this.updateStrategy = new FileUpdateStrategy(this.options.getRepositoryUrl());
        } else {
            return;
        }
        this.window = new BootstrapWindow();
        new WindowThread(this.window).start();
        this.window.label.setText("Connecting to repository " + this.options.getRepositoryUrl());
        this.logger.info("Looking for new Kipeto Jar at {}", (Object)this.updateStrategy.getUpdateUrl());
        boolean updateFound = this.updateStrategy.isUpdateAvailable(this.jar);
        if (updateFound) {
            this.logger.info("Update needed");
            this.update();
        } else {
            this.logger.info("No Update needed");
        }
        this.window.setEnabled(false);
        this.window.dispose();
    }

    private void update() throws Exception {
        this.window.setVisible(true);
        File tempDir = new File(this.options.getData(), TEMP_DIR);
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw new RuntimeException("Could not create <" + tempDir + ">");
        }
        File tempFile = File.createTempFile(this.getClass().getName(), ".jar", tempDir);
        this.logger.debug("Downloading {} to {}", (Object)this.updateStrategy.getUpdateUrl(), (Object)tempFile);
        CountingOutputStream destinationStream = new CountingOutputStream((OutputStream)new FileOutputStream(tempFile));
        destinationStream.addByteTransferListener((ByteTransferListener)new ProgressListener());
        this.updateLength = this.updateStrategy.getUpdateSize();
        Date lastModified = this.updateStrategy.downloadUpdate((OutputStream)destinationStream);
        if (this.jar.exists()) {
            this.logger.debug("Deleting {}", (Object)this.jar);
            if (!this.jar.delete()) {
                throw new RuntimeException("Could not delete <" + this.jar + ">");
            }
        }
        tempFile.setLastModified(lastModified.getTime());
        this.logger.debug("Moving {} to {}", (Object)tempFile, (Object)this.jar);
        if (!tempFile.renameTo(this.jar)) {
            throw new RuntimeException("Could not rename <" + tempFile + "> to <" + this.jar + ">");
        }
    }

    private class WindowThread
    extends Thread {
        public WindowThread(final JFrame window) {
            super(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (window.isEnabled()) {
                        window.setVisible(true);
                    }
                }
            });
        }
    }

    private final class ProgressListener
    implements ByteTransferListener {
        private ProgressListener() {
        }

        public void handleByteTransfer(ByteTransferEvent event) {
            ((BootstrapApp)BootstrapApp.this).window.progressBar.setMaximum((int)BootstrapApp.this.updateLength);
            ((BootstrapApp)BootstrapApp.this).window.progressBar.setValue((int)event.getBytesSinceBeginOfOperation());
            String progress = FileSizeFormatter.formateBytes((long)event.getBytesSinceBeginOfOperation(), (int)2);
            String total = FileSizeFormatter.formateBytes((long)BootstrapApp.this.updateLength, (int)2);
            ((BootstrapApp)BootstrapApp.this).window.label.setText(String.format("Downloading %s (%s von %s)", BootstrapApp.this.updateStrategy.getUpdateUrl(), progress, total));
        }
    }
}

