/*
 * Decompiled with CFR 0.152.
 */
package de.ecclesia.kipeto.common.util;

import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Strings {
    private static final String CROP_STRING = "...";

    public static String crop(String source, int length) {
        String croppedString;
        if (source.length() <= length) {
            return source;
        }
        if (length > 3) {
            croppedString = source.substring(0, length - 3);
            croppedString = croppedString + CROP_STRING;
        } else {
            croppedString = source.substring(0, length);
        }
        return croppedString;
    }

    public static String padLeft(String source, int paddingSize, String paddingString) {
        String target = source;
        while (target.length() < paddingSize) {
            target = paddingString + target;
        }
        return target;
    }

    public static String padRight(String source, int paddingSize, String paddingString) {
        String target = source;
        while (target.length() < paddingSize) {
            target = target + paddingString;
        }
        return target;
    }

    public static String firstNonNull(String ... strings) {
        for (String string : strings) {
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public static boolean equalsAtLeastOne(String string, String ... conditions) {
        for (String condition : conditions) {
            if (!string.equalsIgnoreCase(condition)) continue;
            return true;
        }
        return false;
    }

    public static String join(String delimiter, String ... strings) {
        String result = "";
        for (String string : strings) {
            if (string == null || string.length() <= 0) continue;
            if (result.length() > 0) {
                result = result + delimiter;
            }
            result = result + string;
        }
        return result;
    }

    public static String capitalize(String string) {
        if (string.length() > 0) {
            char[] chars = string.toLowerCase().toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            string = String.valueOf(chars);
        }
        return string;
    }

    public static String sanitize(String unsanitizedString) {
        if (unsanitizedString == null) {
            return null;
        }
        unsanitizedString = unsanitizedString.replace('\u201e', '\"');
        unsanitizedString = unsanitizedString.replace('\u201c', '\"');
        unsanitizedString = unsanitizedString.replace(String.valueOf('\u001a'), " ");
        return unsanitizedString;
    }

    public static String longestStringOf(Collection<String> strings) {
        String longest = null;
        for (String string : strings) {
            if (longest != null && (string == null || string.length() <= longest.length())) continue;
            longest = string;
        }
        return longest;
    }
}

