/*
 * Decompiled with CFR 0.152.
 */
package de.ecclesia.kipeto.common.util;

import de.ecclesia.kipeto.common.util.ByteTransferEvent;
import de.ecclesia.kipeto.common.util.ByteTransferListener;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CountingOutputStream
extends FilterOutputStream {
    private static final int DEFAULT_THRESHOLD = 20480;
    private List<ByteTransferListener> byteEventListeners = new ArrayList<ByteTransferListener>();
    private long count;
    private long countAtLastEvent;
    private int threshold;

    public CountingOutputStream(OutputStream out) {
        this(out, 20480);
    }

    public CountingOutputStream(OutputStream out, int threshold) {
        super(out);
        this.threshold = threshold;
    }

    public void write(int b) throws IOException {
        super.write(b);
        this.updateCount(1);
    }

    public void close() throws IOException {
        super.close();
        this.updateCount(-1);
    }

    public long getCount() {
        return this.count;
    }

    private void updateCount(int bytes) {
        if (bytes == -1) {
            ByteTransferEvent event = new ByteTransferEvent(this.count, this.count - this.countAtLastEvent, this.threshold, true);
            this.fireByteTransferEvent(event);
        } else {
            this.count += (long)bytes;
            if (this.count - this.countAtLastEvent >= (long)this.threshold) {
                ByteTransferEvent event = new ByteTransferEvent(this.count, this.count - this.countAtLastEvent, this.threshold, false);
                this.fireByteTransferEvent(event);
                this.countAtLastEvent = this.count;
            }
        }
    }

    public void addByteTransferListener(ByteTransferListener listener) {
        this.byteEventListeners.add(listener);
    }

    public void removeByteTransferListener(ByteTransferListener listener) {
        this.byteEventListeners.remove(listener);
    }

    protected void fireByteTransferEvent(ByteTransferEvent byteTransferEvent) {
        for (ByteTransferListener listener : this.byteEventListeners) {
            listener.handleByteTransfer(byteTransferEvent);
        }
    }

    public long getByteCount() {
        return this.count;
    }
}

