/*
 * Decompiled with CFR 0.152.
 */
package de.ecclesia.kipeto.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseOptions {
    @Option(name="-l", aliases={"--logLevel"}, usage="Log Level")
    protected String logLevel;
    @Option(name="-r", aliases={"--repository"}, usage="Remote-Repository URL like 'ssh://user@updates01.ecclesia:/srv/www/htdocs/repos", metaVar="URL")
    protected String repositoryUrl;
    @Option(name="-p", aliases={"--password"}, usage="Password")
    protected String password;
    @Option(name="-k", aliases={"--privateKeyFile"}, usage="Private Key File", metaVar="URL")
    protected String privateKey;
    @Option(name="-pf", aliases={"--parmFile"}, usage="File which contains command line parameters")
    protected File parameterFile;
    private CmdLineParser parser;

    public BaseOptions() {
    }

    public BaseOptions(String[] args) {
        this.parse(args);
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public File getParameterFile() {
        return this.parameterFile;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    protected void parse(String[] args) {
        String[] preProcessedArgs = this.preProcessArguments(args);
        this.parser = new CmdLineParser(this);
        this.parser.setUsageWidth(130);
        try {
            this.parser.parseArgument(preProcessedArgs);
            String[] pfArgs = this.getParameterFileArguments(this.parameterFile);
            this.parser.parseArgument(pfArgs);
            this.checkRequiredArguments();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            this.parser.printUsage(System.err);
            System.err.println();
            System.exit(1);
        }
    }

    public String[] getParameterFileArguments(File parameterFile) {
        if (parameterFile == null) {
            return new String[0];
        }
        try {
            String[] parameterFileArguments = this.unsafeGetParameterFileArguments(parameterFile);
            return this.preProcessArguments(parameterFileArguments);
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    private String[] unsafeGetParameterFileArguments(File parameterFile) throws IOException {
        Properties properties = new Properties();
        FileInputStream parmFileStream = new FileInputStream(parameterFile);
        properties.load(parmFileStream);
        parmFileStream.close();
        ArrayList<String> parmList = new ArrayList<String>();
        for (String key : properties.stringPropertyNames()) {
            parmList.add(key);
            String property = properties.getProperty(key);
            if (property == null || property.isEmpty()) continue;
            parmList.add(property);
        }
        String[] newArgs = parmList.toArray(new String[parmList.size()]);
        return newArgs;
    }

    protected void checkRequiredArguments() throws CmdLineException {
        this.checkRequiredArgument(BaseOptions.class, "repositoryUrl");
    }

    protected void checkRequiredArgument(Class<? extends BaseOptions> optionClass, String fieldName) throws CmdLineException {
        try {
            Field field = optionClass.getDeclaredField(fieldName);
            try {
                field.setAccessible(true);
                Option option = field.getAnnotation(Option.class);
                Object value = field.get(this);
                if (value != null) {
                    return;
                }
                String optionName = option.name();
                throw new CmdLineException(this.parser, "Option must be set: " + optionName);
            }
            finally {
                field.setAccessible(false);
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException("Field access failed. This is a bug!", e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Field access failed. This is a bug!", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Field access failed. This is a bug!", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Field access failed. This is a bug!", e);
        }
    }

    protected String[] preProcessArguments(String[] argsArray) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(argsArray));
        args.remove("-console");
        return args.toArray(new String[args.size()]);
    }
}

