/*
 * Decompiled with CFR 0.152.
 */
package de.ecclesia.kipeto.bootstrap;

import de.ecclesia.kipeto.bootstrap.IUpdateStrategy;
import de.ecclesia.kipeto.common.util.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUpdateStrategy
implements IUpdateStrategy {
    private static final Logger log = LoggerFactory.getLogger(FileUpdateStrategy.class);
    private File remoteJarFile;

    public FileUpdateStrategy(String repositoryUrl) {
        File repositoryDir = new File(repositoryUrl);
        this.remoteJarFile = new File(repositoryDir, "dist/kipeto.jar");
    }

    public boolean isUpdateAvailable(File localJarFile) throws Exception {
        if (!localJarFile.exists()) {
            log.debug("Local jar file is missing");
            return this.remoteJarFile.exists();
        }
        long localLength = localJarFile.length();
        long remoteLength = this.remoteJarFile.length();
        long localLastModified = localJarFile.lastModified();
        long remoteLastModified = this.remoteJarFile.lastModified();
        log.debug("Local jar length: {}; lastModified: {}", new Object[]{localLength, localLastModified});
        log.debug("Remote jar length: {}; lastModified: {}", new Object[]{remoteLength, remoteLastModified});
        if (localLength != remoteLength || localLastModified != remoteLastModified) {
            log.debug("Local jar file is outdated");
            return true;
        }
        return false;
    }

    public String getUpdateUrl() {
        return this.remoteJarFile.getAbsolutePath();
    }

    public long getUpdateSize() {
        return this.remoteJarFile.length();
    }

    public Date downloadUpdate(OutputStream destinationStream) throws Exception {
        Streams.copyStream(new FileInputStream(this.remoteJarFile), destinationStream, true);
        return new Date(this.remoteJarFile.lastModified());
    }
}

