/*
 * Decompiled with CFR 0.152.
 */
package de.ecclesia.kipeto.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Streams {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBufferedStream(BufferedInputStream sourceStream, BufferedOutputStream destinationStream, boolean closeStreams) throws IOException {
        byte[] buffer = new byte[8192];
        int bytesRead = 0;
        try {
            while ((bytesRead = sourceStream.read(buffer)) != -1) {
                destinationStream.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (closeStreams) {
                sourceStream.close();
                destinationStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream sourceStream, OutputStream destinationStream, boolean closeStreams) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(destinationStream);
        try {
            Streams.copyBufferedStream(new BufferedInputStream(sourceStream), bufferedOutputStream, closeStreams);
        }
        finally {
            if (!closeStreams) {
                bufferedOutputStream.flush();
            }
        }
    }

    public static void ensureClosed(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getBytes(InputStream sourceStream, boolean closeStream) throws IOException {
        ByteArrayOutputStream destinationStream = new ByteArrayOutputStream();
        Streams.copyStream(sourceStream, destinationStream, closeStream);
        return destinationStream.toByteArray();
    }
}

