/*
 * Decompiled with CFR 0.152.
 */
package de.ecclesia.kipeto.common.util;

import de.ecclesia.kipeto.common.util.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.omg.CORBA.SystemException;

public class HashUtil {
    public static String hashFile(File file, String hashAlgorithm) throws SystemException, IOException {
        return HashUtil.hashStream(new FileInputStream(file), hashAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hashStream(InputStream stream, String hashAlgorithm) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(hashAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        int readBytes = 0;
        byte[] buffer = new byte[8192];
        try {
            while ((readBytes = stream.read(buffer)) != -1) {
                digest.update(buffer, 0, readBytes);
            }
        }
        finally {
            Streams.ensureClosed(stream);
        }
        return HashUtil.convertHashBytesToString(digest.digest());
    }

    public static String convertHashBytesToString(byte[] hash) {
        return String.format("%0" + hash.length * 2 + "x", new BigInteger(1, hash));
    }
}

