/*
 * Decompiled with CFR 0.152.
 */
package de.ecclesia.kipeto.common.util;

import de.ecclesia.kipeto.common.util.Assert;
import de.ecclesia.kipeto.common.util.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class Files {
    public static boolean deleteDirectory(File directory) {
        Files.clearDirectory(directory);
        return directory.delete();
    }

    public static boolean clearDirectory(File directory) {
        Assert.isTrue(directory.isDirectory(), "Parameter ist kein Verzeichnis");
        File[] files = directory.listFiles();
        boolean allDeleted = true;
        for (File file : files) {
            if (file.isDirectory()) {
                Files.clearDirectory(file);
            }
            allDeleted &= file.delete();
        }
        return allDeleted;
    }

    public static void copyFile(File sourceFile, File destinationFile) throws FileNotFoundException, IOException {
        Streams.copyStream(new FileInputStream(sourceFile), new FileOutputStream(destinationFile), true);
    }

    public static void writeBytesToFile(byte[] bytes, File destinationFile) throws FileNotFoundException, IOException {
        Streams.copyStream(new ByteArrayInputStream(bytes), new FileOutputStream(destinationFile), true);
    }

    public static byte[] readBytesFromFile(File sourceFile) throws FileNotFoundException, IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream((int)sourceFile.length());
        Streams.copyStream(new FileInputStream(sourceFile), byteStream, true);
        return byteStream.toByteArray();
    }

    public static void writeStringToFile(String string, File destinationFile) throws FileNotFoundException, IOException {
        Files.writeBytesToFile(string.getBytes("UTF-8"), destinationFile);
    }

    public static String readStringFromFile(File sourceFile) throws FileNotFoundException, IOException {
        byte[] bytes = Files.readBytesFromFile(sourceFile);
        String string = new String(bytes, "UTF-8");
        return string.intern();
    }
}

