/*
 * Decompiled with CFR 0.152.
 */
package de.ecclesia.kipeto.common.util;

import de.ecclesia.kipeto.common.util.ByteTransferEvent;
import de.ecclesia.kipeto.common.util.ByteTransferListener;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class CountingInputStream
extends FilterInputStream {
    private static final int DEFAULT_THRESHOLD = 20480;
    private List<ByteTransferListener> byteEventListeners = new ArrayList<ByteTransferListener>();
    private long count;
    private long countAtLastEvent;
    private int threshold;

    public CountingInputStream(InputStream in) {
        this(in, 20480);
    }

    public CountingInputStream(InputStream in, int threshold) {
        super(in);
        this.threshold = threshold;
    }

    public int read(byte[] b) throws IOException {
        int found = super.read(b);
        this.updateCount(found);
        return found;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int found = super.read(b, off, len);
        this.updateCount(found);
        return found;
    }

    public int read() throws IOException {
        this.updateCount(1);
        return super.read();
    }

    public long getCount() {
        return this.count;
    }

    public void close() throws IOException {
        this.updateCount(-1);
        super.close();
    }

    private void updateCount(int read) {
        if (read == -1) {
            ByteTransferEvent event = new ByteTransferEvent(this.count, this.count - this.countAtLastEvent, this.threshold, true);
            this.fireByteTransferEvent(event);
        } else {
            this.count += (long)read;
            if (this.count - this.countAtLastEvent >= (long)this.threshold) {
                ByteTransferEvent event = new ByteTransferEvent(this.count, this.count - this.countAtLastEvent, this.threshold, false);
                this.fireByteTransferEvent(event);
                this.countAtLastEvent = this.count;
            }
        }
    }

    public void addByteTransferListener(ByteTransferListener listener) {
        this.byteEventListeners.add(listener);
    }

    public void removeByteTransferListener(ByteTransferListener listener) {
        this.byteEventListeners.remove(listener);
    }

    protected void fireByteTransferEvent(ByteTransferEvent byteTransferEvent) {
        for (ByteTransferListener listener : this.byteEventListeners) {
            listener.handleByteTransfer(byteTransferEvent);
        }
    }

    public long getByteCount() {
        return this.count;
    }
}

