/*
 * Decompiled with CFR 0.152.
 */
package de.ecclesia.kipeto.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWTExceptionErrorDialog
extends JDialog
implements ActionListener {
    protected JList messageList;
    protected JTextArea stackTraceView;

    public AWTExceptionErrorDialog(Exception exception) {
        this(null, exception);
    }

    public AWTExceptionErrorDialog(Frame parent, Exception exception) {
        super(parent, "Error");
        String nativeLF = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(nativeLF);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setModal(true);
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(12, 12, 12, 12));
        panel.setLayout(new BorderLayout(12, 12));
        StringWriter stackTraceWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stackTraceWriter));
        String stackTrace = stackTraceWriter.toString();
        JLabel messageLabel = new JLabel("Fehler beim Aktualisieren. \nBitte wenden Sie sich an Ihren Administrator.");
        panel.add((Component)messageLabel, "North");
        Box box = new Box(1);
        ArrayList<String> tempExceptionList = new ArrayList<String>();
        this.addExceptionsToList(exception, tempExceptionList);
        this.messageList = new JList<Object>(tempExceptionList.toArray());
        JScrollPane messageListScrollPane = new JScrollPane(this.messageList);
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder border2 = BorderFactory.createTitledBorder(border, "Nested messages :");
        CompoundBorder border3 = BorderFactory.createCompoundBorder(border2, messageListScrollPane.getBorder());
        messageListScrollPane.setBorder(border3);
        messageListScrollPane.setPreferredSize(new Dimension(400, 80));
        box.add(messageListScrollPane);
        this.stackTraceView = new JTextArea(stackTrace);
        this.stackTraceView.setFont(new Font("Monospaced", 0, 12));
        this.stackTraceView.setCaretPosition(0);
        this.stackTraceView.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.stackTraceView);
        scrollPane.setPreferredSize(new Dimension(400, 200));
        Border border4 = BorderFactory.createEtchedBorder(1);
        TitledBorder border5 = BorderFactory.createTitledBorder(border4, "Stacktrace :");
        CompoundBorder border6 = BorderFactory.createCompoundBorder(border5, scrollPane.getBorder());
        scrollPane.setBorder(border6);
        box.add(scrollPane);
        panel.add((Component)box, "Center");
        Box buttons = new Box(0);
        buttons.add(Box.createGlue());
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("close");
        closeButton.addActionListener(this);
        buttons.add(closeButton);
        panel.add((Component)buttons, "South");
        this.setContentPane(panel);
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
    }

    public void addExceptionsToList(Throwable e, List<String> list) {
        list.add(e.getMessage());
        if (e.getCause() != null) {
            this.addExceptionsToList(e.getCause(), list);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("close")) {
            this.dispose();
        }
    }
}

