/*
 * Decompiled with CFR 0.152.
 */
package de.ecclesia.kipeto.bootstrap;

import de.ecclesia.kipeto.bootstrap.IUpdateStrategy;
import de.ecclesia.kipeto.common.util.Streams;
import java.io.File;
import java.io.OutputStream;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUpdateStrategy
implements IUpdateStrategy {
    private static final Logger log = LoggerFactory.getLogger(HttpUpdateStrategy.class);
    private String jarUrl;
    private DefaultHttpClient client;
    private long contentLength;

    public HttpUpdateStrategy(String repositoryUrl) {
        this.jarUrl = String.format("%s/%s/%s", repositoryUrl, "dist", "kipeto.jar");
        this.client = new DefaultHttpClient();
    }

    public String getUpdateUrl() {
        return this.jarUrl;
    }

    public long getUpdateSize() {
        return this.contentLength;
    }

    public Date downloadUpdate(OutputStream destinationStream) throws Exception {
        HttpGet httpget = new HttpGet();
        HttpResponse contentResponse = this.client.execute(httpget);
        HttpEntity entity = contentResponse.getEntity();
        Header lastModifiedHeader = contentResponse.getFirstHeader("Last-Modified");
        Date lastModified = DateUtils.parseDate(lastModifiedHeader.getValue());
        int statusCode = contentResponse.getStatusLine().getStatusCode();
        log.debug("HttpGet at {}, Status is {}", (Object)this.jarUrl, (Object)statusCode);
        if (statusCode != 200) {
            throw new RuntimeException(contentResponse.getStatusLine().toString());
        }
        Streams.copyStream(entity.getContent(), destinationStream, true);
        return lastModified;
    }

    public boolean isUpdateAvailable(File localJarFile) throws Exception {
        HttpHead httpHead = new HttpHead(this.jarUrl);
        HttpResponse headResponse = this.client.execute(httpHead);
        int statusCode = headResponse.getStatusLine().getStatusCode();
        log.debug("HttpHead at {}, Status is {}", (Object)this.jarUrl, (Object)statusCode);
        if (statusCode != 200) {
            throw new RuntimeException(headResponse.getStatusLine().toString());
        }
        Header lastModifiedHeader = headResponse.getFirstHeader("Last-Modified");
        Date lastModified = DateUtils.parseDate(lastModifiedHeader.getValue());
        log.debug("HttpHead {} - Last-Modified: {}", (Object)this.jarUrl, (Object)lastModified);
        Header contentLengthHeader = headResponse.getFirstHeader("Content-Length");
        this.contentLength = Long.parseLong(contentLengthHeader.getValue());
        log.debug("HttpHead {} - Content-Length: {}", (Object)this.jarUrl, (Object)this.contentLength);
        log.debug("Local Kipeto Jar {} - Last-Modified: {}", localJarFile, (Object)new Date(localJarFile.lastModified()));
        log.debug("Local Kipeto Jar {} - Content-Length: {}", localJarFile, (Object)localJarFile.length());
        return !localJarFile.exists() || lastModified.getTime() != localJarFile.lastModified() || this.contentLength != localJarFile.length();
    }
}

