/*
 * Decompiled with CFR 0.152.
 */
package de.eacg.ecs.plugin;

import de.eacg.ecs.client.CheckResults;
import de.eacg.ecs.client.Dependency;
import de.eacg.ecs.client.RestClient;
import de.eacg.ecs.client.Scan;
import de.eacg.ecs.plugin.ScanAndTransferMojo;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="dependency-check", defaultPhase=LifecyclePhase.DEPLOY, requiresDependencyResolution=ResolutionScope.TEST)
public class ScanAndCheckMojo
extends ScanAndTransferMojo {
    @Parameter(property="licenseCheck.allowBreakBuild", defaultValue="true")
    private boolean allowBreakBuild;
    @Parameter(property="licenseCheck.breakOnLegalIssues", defaultValue="true")
    private boolean breakOnLegalIssues;
    @Parameter(property="licenseCheck.breakOnVulnerabilities", defaultValue="true")
    private boolean breakOnVulnerabilities;
    @Parameter(property="licenseCheck.breakOnViolationsOnly", defaultValue="true")
    private boolean breakOnViolationsOnly;
    @Parameter(property="licenseCheck.breakOnViolationsAndWarnings", defaultValue="false")
    private boolean breakOnViolationsAndWarnings;
    @Parameter(property="licenseCheck.assumeComponentsModified", defaultValue="false")
    private boolean assumeComponentsModified;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        Dependency dependency = this.createDependency();
        CheckResults results = null;
        try {
            Scan scan = this.createScan(dependency);
            RestClient restClient = this.createRestClient();
            results = restClient.checkScan(scan);
            if (restClient.getResponseStatus() != 200) {
                throw new MojoExecutionException("Failed : HTTP error code : " + restClient.getResponseStatus());
            }
            if (results == null) {
                throw new MojoExecutionException("Failed : cannot parse server response");
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Calling Rest API failed", (Throwable)e);
            throw new MojoExecutionException("Exception while calling Rest API", e);
        }
        this.evaluateResults(results);
    }

    private void evaluateResults(CheckResults results) throws MojoFailureException {
        String msg;
        for (CheckResults.Warning w : results.getWarnings()) {
            String cStr = w.getComponent();
            String vStr = w.getVersion();
            msg = String.format("Component \"%s %s\"", cStr != null ? cStr : "", vStr != null ? vStr : "");
            if (w.isComponentNotFound()) {
                this.getLog().warn((CharSequence)(msg + " component not found"));
            }
            if (w.isVersionNotFound()) {
                this.getLog().warn((CharSequence)(msg + " version not found"));
            }
            if (!w.isLicenseNotFound()) continue;
            this.getLog().warn((CharSequence)(msg + " license not found"));
        }
        if (!this.allowBreakBuild) {
            return;
        }
        if (this.breakOnLegalIssues) {
            int violations = 0;
            int warnings = 0;
            for (CheckResults.Result result : results.getData()) {
                msg = result.getComponent().getName() + " " + result.getComponent().getVersion();
                List legalViolations = this.assumeComponentsModified ? result.getChanged().getViolations() : result.getNot_changed().getViolations();
                for (CheckResults.Violation v : legalViolations) {
                    if (v.isViolation()) {
                        this.getLog().error((CharSequence)(msg + ": " + v.getMessage()));
                        ++violations;
                        continue;
                    }
                    if (!v.isWarning()) continue;
                    this.getLog().warn((CharSequence)(msg + ": " + v.getMessage()));
                    ++warnings;
                }
            }
            if (this.breakOnViolationsAndWarnings && (warnings > 0 || violations > 0)) {
                throw new MojoFailureException("Found legal violations");
            }
            if (this.breakOnViolationsOnly && violations > 0) {
                throw new MojoFailureException("Found legal violations");
            }
        }
        if (this.breakOnVulnerabilities) {
            int violations = 0;
            int warnings = 0;
            for (CheckResults.Result result : results.getData()) {
                String componentStr = result.getComponent().getName() + " " + result.getComponent().getVersion();
                for (CheckResults.Vulnerabilities v : result.getVulnerabilities()) {
                    String msg2 = componentStr + ": [" + v.getName() + "] " + v.getDescription();
                    if (v.isViolation()) {
                        this.getLog().error((CharSequence)msg2);
                        ++violations;
                        continue;
                    }
                    if (!v.isWarning()) continue;
                    this.getLog().warn((CharSequence)msg2);
                    ++warnings;
                }
            }
            if (this.breakOnViolationsAndWarnings && (warnings > 0 || violations > 0)) {
                throw new MojoFailureException("Found vulnerabilities");
            }
            if (this.breakOnViolationsOnly && violations > 0) {
                throw new MojoFailureException("Found vulnerabilities");
            }
        }
    }
}

