/*
 * Decompiled with CFR 0.152.
 */
package de.eacg.ecs.plugin.rest;

import de.eacg.ecs.plugin.ProjectProperties;
import de.eacg.ecs.plugin.rest.Scan;
import java.net.ProxySelector;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;

public class RestApi {
    private final String baseUrl;
    private final String apiPath;
    private final String apiKey;
    private final String user;
    private final Client client;
    private int responseStatus = -1;

    public RestApi(String baseUrl, String apiPath, String apiKey, String user) {
        this.baseUrl = baseUrl;
        this.apiPath = apiPath;
        this.apiKey = apiKey;
        this.user = user;
        this.client = RestApi.createClient();
    }

    public String transferScan(Scan scan) throws Exception {
        ProjectProperties props = new ProjectProperties();
        Response response = this.client.target(this.baseUrl).path(this.apiPath).path("scans").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("User-Agent", (Object)(props.getProperty("artifactId") + "/" + props.getProperty("version"))).header("X-ApiKey", (Object)this.apiKey).header("X-User", (Object)this.user).buildPost(Entity.json((Object)scan)).invoke();
        this.responseStatus = response.getStatus();
        return (String)response.readEntity(String.class);
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    private static Client createClient() {
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        CloseableHttpClient httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
        ApacheHttpClient4Engine engine = new ApacheHttpClient4Engine((HttpClient)httpClient);
        return new ResteasyClientBuilder().httpEngine((ClientHttpEngine)engine).build();
    }
}

