/*
 * Decompiled with CFR 0.152.
 */
package de.eacg.ecs.plugin;

import de.eacg.ecs.plugin.ChecksumCreator;
import de.eacg.ecs.plugin.ComponentId;
import de.eacg.ecs.plugin.JsonCredentials;
import de.eacg.ecs.plugin.MavenProjectDependenciesConfiguratorImpl;
import de.eacg.ecs.plugin.rest.Dependency;
import de.eacg.ecs.plugin.rest.RestApi;
import de.eacg.ecs.plugin.rest.Scan;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.mojo.license.api.DefaultThirdPartyHelper;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.model.LicenseMap;

@Mojo(name="dependency-scan", defaultPhase=LifecyclePhase.DEPLOY, requiresDependencyResolution=ResolutionScope.TEST)
public class ScanAndTransferMojo
extends AbstractMojo {
    @Parameter(property="licenseScan.verbose", defaultValue="${maven.verbose}")
    private boolean verbose;
    @Parameter(property="licenseScan.projectName")
    private String projectName;
    @Parameter(property="licenseScan.moduleName", defaultValue="${project.name}")
    private String moduleName;
    @Parameter(property="licenseScan.moduleId", defaultValue="${project.groupId}:${project.artifactId}")
    private String moduleId;
    @Parameter(property="licenseScan.baseUrl", defaultValue="https://ecs-app.eacg.de")
    private String baseUrl;
    @Parameter(property="licenseScan.apiPath", defaultValue="/api/v1")
    private String apiPath;
    @Parameter(property="licenseScan.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="licenseScan.skipTransfer", defaultValue="false")
    private boolean skipTransfer;
    @Parameter(property="licenseScan.scope", defaultValue="runtime")
    private String scope;
    @Parameter(property="licenseScan.credentials")
    private String credentials;
    @Parameter(property="licenseScan.userName")
    private String userName;
    @Parameter(property="licenseScan.apiKey")
    private String apiKey;
    @Parameter(property="licenseScan.privateComponents", defaultValue="${project.groupId}")
    private String privateComponents;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    private MavenProject mavenProject;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project.build.sourceEncoding}", readonly=true)
    private String encoding;
    @Component
    private DependenciesTool dependenciesTool;
    @Component
    private ThirdPartyTool thirdPartyTool;
    private String[] privateComponentArr = null;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"skip flag is on, will skip goal.");
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.verbose = true;
        }
        JsonCredentials credentials = this.readAndCheckCredentials();
        Dependency dependency = this.createDependency();
        if (this.skipTransfer) {
            this.getLog().info((CharSequence)"Skipping rest transfer");
        } else {
            try {
                Scan scan = new Scan(this.projectName, this.moduleName, this.moduleId, dependency);
                RestApi restApi = new RestApi(this.baseUrl, this.apiPath, credentials.getApiKey(this.apiKey), credentials.getUser(this.userName));
                this.transferScan(restApi, scan);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Calling Rest API failed", (Throwable)e);
                throw new MojoExecutionException("Exception while calling Rest API", e);
            }
        }
    }

    private Dependency createDependency() throws MojoExecutionException {
        try {
            LicenseMap licenseMap = this.createLicenseMap();
            ArtifactFilter artifactFilter = this.createResolvingArtifactFilter();
            DependencyNode rootNode = this.dependencyGraphBuilder.buildDependencyGraph(this.mavenProject, artifactFilter);
            Set licenseAndProjectSet = licenseMap.entrySet();
            Set<Map.Entry<MavenProject, String[]>> projectsAndLicenseSet = licenseMap.toDependencyMap().entrySet();
            ArrayList<String> ownLicenses = new ArrayList<String>();
            for (License lic : this.mavenProject.getModel().getLicenses()) {
                ownLicenses.add(lic.getName());
            }
            String[] ownLicensesArr = ownLicenses.toArray(new String[ownLicenses.size()]);
            HashMap<Object, Object> myOwnMap = new HashMap<Object, Object>();
            myOwnMap.put(this.mavenProject, ownLicensesArr);
            for (Map.Entry entry : projectsAndLicenseSet) {
                myOwnMap.put(entry.getKey(), entry.getValue());
            }
            this.printStats(licenseAndProjectSet, projectsAndLicenseSet);
            return this.createDependencyTree(rootNode, myOwnMap.entrySet());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"License collection failed", (Throwable)e);
            throw new MojoExecutionException("Exception while collecting license information", e);
        }
    }

    private JsonCredentials readAndCheckCredentials() throws MojoExecutionException {
        try {
            JsonCredentials credentials = new JsonCredentials(this.credentials);
            this.checkMandatoryParameter("userName", credentials.getUser(this.userName));
            this.checkMandatoryParameter("apiKey", credentials.getApiKey(this.apiKey));
            return credentials;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Evaluation of user credentials failed", (Throwable)e);
            throw new MojoExecutionException("Exception while evaluating user credentials", e);
        }
    }

    private void checkMandatoryParameter(String name, String p) throws MojoExecutionException {
        if (p == null || p.isEmpty()) {
            String err = String.format("The mandatory parameter '%s' for plugin %s is missing or invalid", name, ComponentId.create(this.mavenProject));
            this.getLog().error((CharSequence)err);
            throw new MojoExecutionException("Exception: " + err);
        }
    }

    private LicenseMap createLicenseMap() {
        DefaultThirdPartyHelper tpHelper = new DefaultThirdPartyHelper(this.mavenProject, this.encoding, this.verbose, this.dependenciesTool, this.thirdPartyTool, this.localRepository, this.remoteRepositories, this.getLog());
        return tpHelper.createLicenseMap(tpHelper.loadDependencies((MavenProjectDependenciesConfigurator)new MavenProjectDependenciesConfiguratorImpl()));
    }

    private String[] getPrivateComponents() {
        if (this.privateComponentArr == null) {
            this.privateComponentArr = this.privateComponents.split(";");
        }
        return this.privateComponentArr;
    }

    private boolean isPrivateComponent(MavenProject project) {
        for (String pc : this.getPrivateComponents()) {
            boolean result;
            String compareString = project.getGroupId();
            if (pc.contains(":")) {
                compareString = compareString + ':' + project.getArtifactId();
            }
            if (!(result = pc.equals(compareString))) continue;
            return true;
        }
        return false;
    }

    private Dependency mapDependency(DependencyNode node, Map<ComponentId, Map.Entry<MavenProject, String[]>> projectLookup) {
        Dependency.Builder builder = new Dependency.Builder();
        Artifact artifact = node.getArtifact();
        ComponentId artifactId = ComponentId.create(artifact);
        Map.Entry<MavenProject, String[]> projectLicensesPair = projectLookup.get(artifactId);
        if (projectLicensesPair == null) {
            projectLicensesPair = projectLookup.get(ComponentId.createFallback(artifact));
        }
        if (projectLicensesPair == null) {
            this.getLog().error((CharSequence)("Something weird happened: no Project found for artifact: " + artifactId));
            return null;
        }
        MavenProject project = projectLicensesPair.getKey();
        String[] licensesArr = projectLicensesPair.getValue();
        builder.setName(project.getName()).setDescription(project.getDescription()).setKey("mvn:" + project.getGroupId() + ':' + project.getArtifactId()).addVersion(project.getVersion()).setHomepageUrl(project.getUrl());
        if (this.isPrivateComponent(project)) {
            builder.setPrivate(true);
        }
        try {
            File file = artifact.getFile();
            if (file != null) {
                builder.setChecksum("sha-1:" + ChecksumCreator.createChecksum(file));
            } else {
                Artifact af = this.findProjectArtifact(artifact);
                if (af != null && af.getFile() != null) {
                    builder.setChecksum("sha-1:" + ChecksumCreator.createChecksum(af.getFile()));
                } else {
                    this.getLog().warn((CharSequence)("Could not generate checksum - no file specified: " + ComponentId.create(artifact)));
                }
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            this.getLog().warn((CharSequence)("Could not generate checksum: " + e.getMessage()));
        }
        if (!(licensesArr == null || licensesArr.length == 1 && "Unknown license".equals(licensesArr[0]))) {
            for (String license : licensesArr) {
                builder.addLicense(license);
            }
        }
        for (DependencyNode childNode : node.getChildren()) {
            Dependency dep = this.mapDependency(childNode, projectLookup);
            if (dep == null) continue;
            builder.addDependency(dep);
        }
        return builder.getDependency();
    }

    private Artifact findProjectArtifact(Artifact other) {
        for (Object obj : this.mavenProject.getArtifacts()) {
            String otherClassifier;
            String myClassifier;
            Artifact self;
            if (obj == other) {
                return (Artifact)obj;
            }
            if (!(obj instanceof Artifact) || !(self = (Artifact)obj).getGroupId().equals(other.getGroupId()) || !self.getArtifactId().equals(other.getArtifactId()) || !self.getVersion().equals(other.getVersion()) || !self.getType().equals(other.getType()) || !(myClassifier = self.getClassifier() == null ? "" : self.getClassifier()).equals(otherClassifier = other.getClassifier() == null ? "" : other.getClassifier())) continue;
            return self;
        }
        return null;
    }

    private Dependency createDependencyTree(DependencyNode rootNode, Set<Map.Entry<MavenProject, String[]>> projectsAndLicenseSet) {
        HashMap<ComponentId, Map.Entry<MavenProject, String[]>> projectLookup = new HashMap<ComponentId, Map.Entry<MavenProject, String[]>>();
        for (Map.Entry<MavenProject, String[]> entry : projectsAndLicenseSet) {
            projectLookup.put(ComponentId.create(entry.getKey()), entry);
        }
        return this.mapDependency(rootNode, projectLookup);
    }

    private void transferScan(RestApi api, Scan scan) throws MojoExecutionException {
        try {
            String body = api.transferScan(scan);
            this.getLog().info((CharSequence)String.format("API Response: code: %d, body: %n%s%n", api.getResponseStatus(), body));
            if (api.getResponseStatus() != 201) {
                throw new MojoExecutionException("Failed : HTTP error code : " + api.getResponseStatus());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception while transferring scan results to server", e);
        }
    }

    private void printStats(Set<Map.Entry<String, SortedSet<MavenProject>>> licenseAndProjectSet, Set<Map.Entry<MavenProject, String[]>> projectsAndLicenseSet) {
        Log log = this.getLog();
        if (log.isInfoEnabled() && this.verbose) {
            log.info((CharSequence)"Dependencies found:");
            for (Map.Entry<Object, Object> entry : projectsAndLicenseSet) {
                MavenProject project = (MavenProject)entry.getKey();
                String[] licenses = (String[])entry.getValue();
                log.info((CharSequence)String.format("%s %s, %s", project.getName(), project.getVersion(), licenses));
            }
        }
        if (log.isInfoEnabled()) {
            log.info((CharSequence)"Licenses found:");
            for (Map.Entry<Object, Object> entry : licenseAndProjectSet) {
                log.info((CharSequence)String.format("%-75s %d", entry.getKey(), ((SortedSet)entry.getValue()).size()));
            }
        }
    }

    private ArtifactFilter createResolvingArtifactFilter() {
        if (this.scope != null) {
            this.getLog().info((CharSequence)String.format("The selected scope is '%s'", this.scope));
            return new ScopeArtifactFilter(this.scope);
        }
        return null;
    }
}

