/*
 * Decompiled with CFR 0.152.
 */
package de.eacg.ecs.plugin.rest;

import de.eacg.ecs.plugin.ProjectProperties;
import de.eacg.ecs.plugin.rest.Authenticator;
import de.eacg.ecs.plugin.rest.Scan;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class RestApi {
    private final String baseUrl;
    private final String apiPath;
    private final String apiKey;
    private final String user;
    private final Client client;
    private int responseStatus = -1;

    public RestApi(String baseUrl, String apiPath, String apiKey, String user) {
        this(baseUrl, apiPath, apiKey, user, null, null);
    }

    public RestApi(String baseUrl, String apiPath, String apiKey, String user, String basicAuthUser, String basicAuthPwd) {
        this.baseUrl = baseUrl;
        this.apiPath = apiPath;
        this.apiKey = apiKey;
        this.user = user;
        this.client = ClientBuilder.newClient();
        if (basicAuthUser != null && basicAuthPwd != null) {
            this.client.register((Object)new Authenticator(basicAuthUser, basicAuthPwd));
        }
    }

    public String transferScan(Scan scan) throws Exception {
        ProjectProperties props = new ProjectProperties();
        Response response = this.client.target(this.baseUrl).path(this.apiPath).path("scans").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("User-Agent", (Object)(props.getProperty("artifactId") + "/" + props.getProperty("version"))).header("X-ApiKey", (Object)this.apiKey).header("X-User", (Object)this.user).buildPost(Entity.json((Object)scan)).invoke();
        this.responseStatus = response.getStatus();
        return (String)response.readEntity(String.class);
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }
}

