/*
 * Decompiled with CFR 0.152.
 */
package de.eacg.ecs.plugin.rest;

import de.eacg.ecs.plugin.rest.License;
import java.util.HashSet;
import java.util.Set;

public class Dependency {
    private final String name;
    private final String description;
    private final String homepageUrl;
    private final String repoUrl;
    private final String key;
    private final Set<String> versions;
    private final boolean priv;
    private final Set<License> licenses;
    private final Set<Dependency> dependencies;
    private final String checksum;

    private Dependency(String name, String description, String key, Set<String> versions, String homepageUrl, String repoUrl, boolean priv, Set<License> licenses, Set<Dependency> dependencies, String checksum) {
        this.name = name;
        this.description = description;
        this.homepageUrl = homepageUrl;
        this.repoUrl = repoUrl;
        this.key = key;
        this.versions = versions;
        this.priv = priv;
        this.licenses = licenses;
        this.dependencies = dependencies;
        this.checksum = checksum;
    }

    public String getName() {
        return this.name;
    }

    public String getHomepageUrl() {
        return this.homepageUrl;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public String getKey() {
        return this.key;
    }

    public Set<String> getVersions() {
        return this.versions;
    }

    public Set<License> getLicenses() {
        return this.licenses;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getPrivate() {
        return this.priv;
    }

    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void addDependency(Dependency dependency) {
        if (this.dependencies == null) {
            throw new IllegalStateException("dependencies not initialized");
        }
        this.dependencies.add(dependency);
    }

    public String getChecksum() {
        return this.checksum;
    }

    public static class Builder {
        private String name;
        private String description;
        private String homepageUrl;
        private String repoUrl;
        private String key;
        private Set<String> versions;
        private boolean priv = false;
        private Set<License> licenses;
        private Set<Dependency> dependencies;
        private String checksum;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setHomepageUrl(String url) {
            this.homepageUrl = url;
            return this;
        }

        public Builder setRepoUrl(String url) {
            this.repoUrl = url;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setVersions(Set<String> versions) {
            this.versions = versions;
            return this;
        }

        public Builder addVersion(String version) {
            this.getVersions().add(version);
            return this;
        }

        public Builder setPrivate(boolean priv) {
            this.priv = priv;
            return this;
        }

        public Builder setChecksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder setLicenses(Set<License> licenses) {
            this.licenses = licenses;
            return this;
        }

        public Builder addLicense(String name) {
            this.getLicenses().add(new License(name));
            return this;
        }

        public Builder addLicense(String name, String url) {
            this.getLicenses().add(new License(name, url));
            return this;
        }

        public Builder addDependency(Dependency dependency) {
            this.getDependencies().add(dependency);
            return this;
        }

        public Dependency getDependency() {
            return new Dependency(this.name, this.description, this.key, this.versions, this.homepageUrl, this.repoUrl, this.priv, this.licenses, this.dependencies, this.checksum);
        }

        private Set<License> getLicenses() {
            if (this.licenses == null) {
                this.licenses = new HashSet<License>();
            }
            return this.licenses;
        }

        private Set<Dependency> getDependencies() {
            if (this.dependencies == null) {
                this.dependencies = new HashSet<Dependency>();
            }
            return this.dependencies;
        }

        private Set<String> getVersions() {
            if (this.versions == null) {
                this.versions = new HashSet<String>();
            }
            return this.versions;
        }
    }
}

