/*
 * Decompiled with CFR 0.152.
 */
package de.eacg.ecs.plugin;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;

public abstract class ComponentId {
    private String id;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComponentId)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.id == null) {
            StringBuilder sb = new StringBuilder(64);
            sb.append(this.getGroupId() == null ? "[inherited]" : this.getGroupId());
            sb.append(":");
            sb.append(this.getArtifactId());
            sb.append(":");
            sb.append(this.getVersion() == null ? "[inherited]" : this.getVersion());
            this.id = sb.toString();
        }
        return this.id;
    }

    public abstract String getGroupId();

    public abstract String getArtifactId();

    public abstract String getVersion();

    public static ComponentId create(MavenProject project) {
        return ComponentId.create(project.getModel());
    }

    public static ComponentId create(final Model model) {
        return new ComponentId(){

            @Override
            public String getGroupId() {
                return model.getGroupId();
            }

            @Override
            public String getArtifactId() {
                return model.getArtifactId();
            }

            @Override
            public String getVersion() {
                return model.getVersion();
            }
        };
    }

    public static ComponentId create(final Artifact artifact) {
        return new ComponentId(){

            @Override
            public String getGroupId() {
                return artifact.getGroupId();
            }

            @Override
            public String getArtifactId() {
                return artifact.getArtifactId();
            }

            @Override
            public String getVersion() {
                return artifact.getVersion();
            }
        };
    }
}

