/*
 * Decompiled with CFR 0.152.
 */
package de.eacg.ecs.client;

import de.eacg.ecs.client.Check;
import de.eacg.ecs.client.CheckError;
import de.eacg.ecs.client.CheckResults;
import de.eacg.ecs.client.Scan;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.ProxySelector;
import java.util.Properties;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.jboss.resteasy.client.jaxrs.engines.HttpContextProvider;
import org.jboss.resteasy.client.jaxrs.internal.ResteasyClientBuilderImpl;

public class RestClient {
    private final String baseUrl;
    private final String apiPath;
    private final String userAgent;
    private final Client client;
    private final Properties properties;
    private int responseStatus = -1;

    public RestClient(Properties properties, String userAgent) {
        this(properties, userAgent, RestClient.createClient(properties));
    }

    RestClient(Properties properties, String userAgent, Client client) {
        this(properties.getProperty("baseUrl"), properties.getProperty("apiPath"), properties, userAgent, client);
    }

    RestClient(String baseUrl, String apiPath, Properties properties, String userAgent, Client client) {
        this.baseUrl = baseUrl;
        this.apiPath = apiPath;
        this.properties = properties;
        this.userAgent = userAgent;
        this.client = client;
    }

    public String transferScan(Scan scan) throws Exception {
        Response response = this.client.target(this.baseUrl).path(this.apiPath).path("core/scans").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("user-agent", (Object)this.userAgent).header("x-api-key", (Object)this.properties.getProperty("apiKey")).buildPost(Entity.json((Object)scan)).invoke();
        this.responseStatus = response.getStatus();
        return (String)response.readEntity(String.class);
    }

    public CheckResults checkScan(Scan scan) throws RestClientException {
        Check check = Check.from(scan);
        Response response = this.client.target(this.baseUrl).path(this.apiPath).path("compliance/check/component").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("user-agent", (Object)this.userAgent).header("x-api-key", (Object)this.properties.getProperty("apiKey")).buildPost(Entity.json((Object)check)).invoke();
        this.responseStatus = response.getStatus();
        if (this.responseStatus == 200) {
            return (CheckResults)response.readEntity(CheckResults.class);
        }
        if (this.responseStatus >= 400 && this.responseStatus < 500) {
            CheckError err = (CheckError)response.readEntity(CheckError.class);
            String msg = err.getMessage();
            if (msg == null) {
                msg = err.getError();
            }
            throw new RestClientException(msg);
        }
        throw new RestClientException("Calling Rest API failed with error code " + this.responseStatus);
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    private static Client createClient(Properties properties) {
        ApacheHttpClient43Engine engine;
        String proxyUrl = properties.getProperty("proxyUrl", "");
        String proxyPort = properties.getProperty("proxyPort", "8080");
        String proxyUser = properties.getProperty("proxyUser", "");
        String proxyPass = properties.getProperty("proxyPass", "");
        if (!proxyUrl.isEmpty()) {
            CloseableHttpClient httpClient;
            HttpHost proxy = new HttpHost(proxyUrl, Integer.parseInt(proxyPort));
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            BasicCredentialsProvider credentialsProvider = null;
            HttpContextProvider contextProvider = null;
            if (!proxyUser.isEmpty()) {
                credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPass));
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(proxy, (AuthScheme)basicAuth);
                HttpClientContext context = HttpClientContext.create();
                context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                context.setAuthCache((AuthCache)authCache);
                contextProvider = () -> context;
            }
            if (credentialsProvider != null) {
                httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
                engine = new ApacheHttpClient43Engine((HttpClient)httpClient, contextProvider);
            } else {
                httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                engine = new ApacheHttpClient43Engine((HttpClient)httpClient);
            }
        } else {
            SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
            CloseableHttpClient httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
            engine = new ApacheHttpClient43Engine((HttpClient)httpClient);
        }
        return new ResteasyClientBuilderImpl().httpEngine((ClientHttpEngine)engine).build();
    }

    public static class RestClientException
    extends Exception {
        public RestClientException(String message) {
            super(message);
        }
    }
}

