/*
 * Decompiled with CFR 0.152.
 */
package de.eacg.ecs.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.eacg.ecs.client.Dependency;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Component {
    private final String key;
    private final String name;
    private final String version;

    public Component(String key, String version) {
        this.key = key;
        this.name = "";
        this.version = version;
    }

    @JsonCreator
    public Component(@JsonProperty(value="key") String key, @JsonProperty(value="name") String name, @JsonProperty(value="version") String version) {
        this.key = key;
        this.name = name;
        this.version = version;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public static List<Component> from(Dependency dependency) {
        ArrayList<Component> components = new ArrayList<Component>();
        String key = dependency.getKey();
        Set<String> versions = dependency.getVersions();
        for (String version : versions) {
            components.add(new Component(key, version));
        }
        for (Dependency dep : dependency.getDependencies()) {
            components.addAll(Component.from(dep));
        }
        return components;
    }
}

