/*
 * Decompiled with CFR 0.152.
 */
package de.eacg.ecs.client;

import de.eacg.ecs.client.Component;
import de.eacg.ecs.client.Dependency;
import de.eacg.ecs.client.Scan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Check {
    private final String projectName;
    private final String moduleName;
    private final List<Component> components;

    public Check(String projectName, String moduleName, List<Component> components) {
        this.projectName = projectName;
        this.moduleName = moduleName;
        this.components = components;
    }

    public Check(String projectName, String moduleName, Component component) {
        this(projectName, moduleName, Collections.singletonList(component));
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public static Check from(Scan scan) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (Dependency dependency : scan.getDependencies()) {
            components.addAll(Component.from(dependency));
        }
        return new Check(scan.getProject(), scan.getModule(), components);
    }
}

