/*
 * Decompiled with CFR 0.152.
 */
package de.eacg.ecs.client;

import de.eacg.ecs.client.Check;
import de.eacg.ecs.client.CheckResults;
import de.eacg.ecs.client.Scan;
import java.net.ProxySelector;
import java.util.Properties;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;

public class RestClient {
    private final String baseUrl;
    private final String apiPath;
    private final String userAgent;
    private final Client client;
    private final Properties properties;
    private int responseStatus = -1;

    public RestClient(Properties properties, String userAgent) {
        this(properties, userAgent, RestClient.createClient(properties));
    }

    RestClient(Properties properties, String userAgent, Client client) {
        this(properties.getProperty("baseUrl"), properties.getProperty("apiPath"), properties, userAgent, client);
    }

    RestClient(String baseUrl, String apiPath, Properties properties, String userAgent, Client client) {
        this.baseUrl = baseUrl;
        this.apiPath = apiPath;
        this.properties = properties;
        this.userAgent = userAgent;
        this.client = client;
    }

    public String transferScan(Scan scan) throws Exception {
        Response response = this.client.target(this.baseUrl).path(this.apiPath).path("scans").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("User-Agent", (Object)this.userAgent).header("X-ApiKey", (Object)this.properties.getProperty("apiKey")).header("X-User", (Object)this.properties.getProperty("userName")).buildPost(Entity.json((Object)scan)).invoke();
        this.responseStatus = response.getStatus();
        return (String)response.readEntity(String.class);
    }

    public CheckResults checkScan(Scan scan) throws Exception {
        Response response = this.client.target(this.baseUrl).path(this.apiPath).path("check_component").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("User-Agent", (Object)this.userAgent).header("X-ApiKey", (Object)this.properties.getProperty("apiKey")).header("X-User", (Object)this.properties.getProperty("userName")).buildPost(Entity.json((Object)Check.from(scan))).invoke();
        this.responseStatus = response.getStatus();
        if (this.responseStatus == 200) {
            return (CheckResults)response.readEntity(CheckResults.class);
        }
        return null;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    private static Client createClient(Properties properties) {
        String proxyUrl = properties.getProperty("proxyUrl", "");
        String proxyPort = properties.getProperty("proxyPort", "8080");
        String proxyUser = properties.getProperty("proxyUser", "");
        String proxyPass = properties.getProperty("proxyPass", "");
        ApacheHttpClient4Engine engine = null;
        if (!proxyUrl.equals("")) {
            CloseableHttpClient httpClient;
            HttpHost proxy = new HttpHost(proxyUrl, Integer.valueOf(proxyPort).intValue());
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            BasicCredentialsProvider credentialsProvider = null;
            HttpClientContext context = null;
            if (!proxyUser.equals("")) {
                credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPass));
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(proxy, (AuthScheme)basicAuth);
                context = HttpClientContext.create();
                context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                context.setAuthCache((AuthCache)authCache);
            }
            if (credentialsProvider != null) {
                httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
                engine = new ApacheHttpClient4Engine((HttpClient)httpClient, context);
            } else {
                httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                engine = new ApacheHttpClient4Engine((HttpClient)httpClient);
            }
        } else {
            SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
            CloseableHttpClient httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
            engine = new ApacheHttpClient4Engine((HttpClient)httpClient);
        }
        return new ResteasyClientBuilder().httpEngine((ClientHttpEngine)engine).build();
    }
}

