/*
 * Decompiled with CFR 0.152.
 */
package de.eacg.ecs.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonProperties
extends Properties {
    public static final String USER_NAME = "userName";
    public static final String API_KEY = "apiKey";
    public static final String BASE_URL = "baseUrl";
    public static final String API_PATH = "apiPath";
    public static final String PROXY_URL = "proxyUrl";
    public static final String PROXY_PORT = "proxyPort";
    public static final String PROXY_USER = "proxyUser";
    public static final String PROXY_PASS = "proxyPass";
    private static final List<String> MANDATORY_KEYS = Arrays.asList("userName", "apiKey", "baseUrl", "apiPath");
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonProperties(String filename) throws IOException {
        this(filename, new Properties());
    }

    public JsonProperties(String filename, Properties defaults) throws IOException {
        super(defaults);
        if (filename != null) {
            File f = new File(filename.replaceAll("^~", System.getProperty("user.home")));
            this.mapProperties((Map)this.mapper.readValue(f, Map.class), "");
        }
    }

    public JsonProperties(InputStream is) throws IOException {
        this(is, new Properties());
    }

    public JsonProperties(InputStream is, Properties defaults) throws IOException {
        super(defaults);
        this.mapProperties((Map)this.mapper.readValue(is, Map.class), "");
    }

    public void setUserName(String userName) {
        this.setPropertyIfNotNull(USER_NAME, userName);
    }

    public void setApiKey(String apiKey) {
        this.setPropertyIfNotNull(API_KEY, apiKey);
    }

    public void setBaseUrl(String baseUrl) {
        this.setPropertyIfNotNull(BASE_URL, baseUrl);
    }

    public void setApiPath(String apiPath) {
        this.setPropertyIfNotNull(API_PATH, apiPath);
    }

    public void setProxyUrl(String proxyUrl) {
        this.setPropertyIfNotNull(PROXY_URL, proxyUrl);
    }

    public void setProxyPort(String proxyPort) {
        this.setPropertyIfNotNull(PROXY_PORT, proxyPort);
    }

    public void setProxyUser(String proxyUser) {
        this.setPropertyIfNotNull(PROXY_USER, proxyUser);
    }

    public void setProxyPass(String proxyPass) {
        this.setPropertyIfNotNull(PROXY_PASS, proxyPass);
    }

    public List<String> validate(String ... keys) {
        ArrayList<String> required = new ArrayList<String>();
        required.addAll(MANDATORY_KEYS);
        required.addAll(Arrays.asList(keys));
        ArrayList<String> errors = new ArrayList<String>();
        for (String key : required) {
            String value = this.getProperty(key);
            if (value != null && !value.isEmpty()) continue;
            errors.add(key);
        }
        return errors;
    }

    private void setPropertyIfNotNull(String key, String value) {
        if (key != null && value != null) {
            this.defaults.setProperty(key, value);
        }
    }

    private void mapProperties(Map<String, Object> props, String prefix) {
        for (Map.Entry<String, Object> e : props.entrySet()) {
            if (String.class.isInstance(e.getValue())) {
                this.setProperty(prefix + e.getKey(), (String)e.getValue());
                continue;
            }
            if (!Map.class.isInstance(e.getValue())) continue;
            this.mapProperties((Map)e.getValue(), prefix + e.getKey() + '.');
        }
    }
}

