/*
 * Decompiled with CFR 0.152.
 */
package de.eacg.ecs.client;

import de.eacg.ecs.client.Check;
import de.eacg.ecs.client.CheckResults;
import de.eacg.ecs.client.Scan;
import java.net.ProxySelector;
import java.util.Properties;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;

public class RestClient {
    private final String baseUrl;
    private final String apiPath;
    private final String userAgent;
    private final Client client;
    private final Properties properties;
    private int responseStatus = -1;

    public RestClient(Properties properties, String userAgent) {
        this(properties, userAgent, RestClient.createClient());
    }

    RestClient(Properties properties, String userAgent, Client client) {
        this(properties.getProperty("baseUrl"), properties.getProperty("apiPath"), properties, userAgent, client);
    }

    RestClient(String baseUrl, String apiPath, Properties properties, String userAgent, Client client) {
        this.baseUrl = baseUrl;
        this.apiPath = apiPath;
        this.properties = properties;
        this.userAgent = userAgent;
        this.client = client;
    }

    public String transferScan(Scan scan) throws Exception {
        Response response = this.client.target(this.baseUrl).path(this.apiPath).path("scans").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("User-Agent", (Object)this.userAgent).header("X-ApiKey", (Object)this.properties.getProperty("apiKey")).header("X-User", (Object)this.properties.getProperty("userName")).buildPost(Entity.json((Object)scan)).invoke();
        this.responseStatus = response.getStatus();
        return (String)response.readEntity(String.class);
    }

    public CheckResults checkScan(Scan scan) throws Exception {
        Response response = this.client.target(this.baseUrl).path(this.apiPath).path("check_component").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("User-Agent", (Object)this.userAgent).header("X-ApiKey", (Object)this.properties.getProperty("apiKey")).header("X-User", (Object)this.properties.getProperty("userName")).buildPost(Entity.json((Object)Check.from(scan))).invoke();
        this.responseStatus = response.getStatus();
        if (this.responseStatus == 200) {
            return (CheckResults)response.readEntity(CheckResults.class);
        }
        return null;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    private static Client createClient() {
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        CloseableHttpClient httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
        ApacheHttpClient4Engine engine = new ApacheHttpClient4Engine((HttpClient)httpClient);
        return new ResteasyClientBuilder().httpEngine((ClientHttpEngine)engine).build();
    }
}

