/*
 * Decompiled with CFR 0.152.
 */
package de.eacg.ecs.client;

import de.eacg.ecs.client.Component;
import java.util.ArrayList;
import java.util.List;

public class CheckResults {
    private boolean ok;
    private List<Warning> warnings;
    private List<Result> data;

    public boolean isOk() {
        return this.ok;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public List<Result> getData() {
        return this.data;
    }

    public static class ComputedStatus {
        private Boolean requireWhitelist;
        private String status;
        private String label;
        private Boolean privateLicense;

        public Boolean getRequireWhitelist() {
            return this.requireWhitelist;
        }

        public String getStatus() {
            return this.status;
        }

        public String getLabel() {
            return this.label;
        }

        public Boolean getPrivateLicense() {
            return this.privateLicense;
        }
    }

    public static class Violation {
        private String type;
        private String message;

        public String getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isWarning() {
            return this.type.equals("warning");
        }

        public boolean isViolation() {
            return this.type.equals("violation");
        }
    }

    public static class Obligation {
        private String type;
        private String message;

        public String getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class LegalAnalysis {
        private List<Obligation> obligations = new ArrayList<Obligation>();
        private List<Violation> violations;
        private ComputedStatus computedStatus;

        public List<Obligation> getObligations() {
            return this.obligations;
        }

        public List<Violation> getViolations() {
            return this.violations;
        }

        public ComputedStatus getComputedStatus() {
            return this.computedStatus;
        }
    }

    public static class Vulnerabilities {
        private String name;
        private String description;
        private String status;

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getStatus() {
            return this.status;
        }

        public boolean isWarning() {
            return this.status.equals("warnings");
        }

        public boolean isViolation() {
            return this.status.equals("violations");
        }
    }

    public static class Result {
        private Component component;
        private String license;
        private LegalAnalysis changed;
        private LegalAnalysis not_changed;
        private List<Vulnerabilities> vulnerabilities;

        public Component getComponent() {
            return this.component;
        }

        public String getLicense() {
            return this.license;
        }

        public LegalAnalysis getChanged() {
            return this.changed;
        }

        public LegalAnalysis getNot_changed() {
            return this.not_changed;
        }

        public List<Vulnerabilities> getVulnerabilities() {
            return this.vulnerabilities;
        }
    }

    public static class Warning {
        private String component;
        private String version;
        private String status;

        public String getComponent() {
            return this.component;
        }

        public String getVersion() {
            return this.version;
        }

        public String getStatus() {
            return this.status;
        }

        public boolean isComponentNotFound() {
            return "component_not_found".equals(this.status);
        }

        public boolean isVersionNotFound() {
            return "version_not_found".equals(this.status);
        }

        public boolean isLicenseNotFound() {
            return "license_not_found".equals(this.status);
        }
    }
}

