/*
 * Decompiled with CFR 0.152.
 */
package de.drippinger.gatling;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import de.drippinger.gatling.Exporter;
import de.drippinger.gatling.ExporterProperties;
import de.drippinger.gatling.GatlingReport;
import de.drippinger.gatling.GitRevisionChecker;
import de.drippinger.gatling.ReportMapper;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mapstruct.factory.Mappers;

public class DynamoDbExporter
implements Exporter {
    public void publish(ExporterProperties properties, Consumer<String> infoLogger) {
        GatlingReport report = this.mapToDynamoTable(properties, this.getSessionKey(properties));
        this.dynamoDbMapper().save((Object)report);
        infoLogger.accept("Wrote " + properties.getSimulations().size() + " request stats to DynamoDB");
    }

    private String getSessionKey(ExporterProperties properties) {
        String session = Objects.isNull(properties.getSessionKey()) ? GitRevisionChecker.currentRevision() : properties.getSessionKey();
        return session;
    }

    private DynamoDBMapper dynamoDbMapper() {
        AmazonDynamoDB amazonDynamoDB = AmazonDynamoDBClientBuilder.defaultClient();
        return new DynamoDBMapper(amazonDynamoDB);
    }

    private GatlingReport mapToDynamoTable(ExporterProperties properties, String session) {
        ReportMapper mapper = (ReportMapper)Mappers.getMapper(ReportMapper.class);
        GatlingReport result = new GatlingReport();
        result.setCommitId(session);
        result.setCurrentTime(ZonedDateTime.now());
        result.setRequests(this.mapToRequests(properties, mapper));
        return result;
    }

    private List<GatlingReport.Request> mapToRequests(ExporterProperties properties, ReportMapper mapper) {
        return properties.getSimulations().stream().flatMap(context -> context.getRequests().stream()).map(mapper::mapToRequest).collect(Collectors.toList());
    }
}

