/*
 * Decompiled with CFR 0.152.
 */
package de.drippinger.fakegen.immutables;

import de.drippinger.fakegen.immutables.BuilderType;
import de.drippinger.fakegen.immutables.SimpleEnum;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableBuilderType
implements BuilderType {
    private final String someString;
    private final SimpleEnum type;

    private ImmutableBuilderType(String someString, SimpleEnum type) {
        this.someString = someString;
        this.type = type;
    }

    @Override
    public String someString() {
        return this.someString;
    }

    @Override
    public SimpleEnum type() {
        return this.type;
    }

    public final ImmutableBuilderType withSomeString(String value) {
        if (this.someString.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "someString");
        return new ImmutableBuilderType(newValue, this.type);
    }

    public final ImmutableBuilderType withType(SimpleEnum value) {
        if (this.type == value) {
            return this;
        }
        SimpleEnum newValue = Objects.requireNonNull(value, "type");
        return new ImmutableBuilderType(this.someString, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBuilderType && this.equalTo((ImmutableBuilderType)another);
    }

    private boolean equalTo(ImmutableBuilderType another) {
        return this.someString.equals(another.someString) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.someString.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "BuilderType{someString=" + this.someString + ", type=" + (Object)((Object)this.type) + "}";
    }

    public static ImmutableBuilderType copyOf(BuilderType instance) {
        if (instance instanceof ImmutableBuilderType) {
            return (ImmutableBuilderType)instance;
        }
        return ImmutableBuilderType.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SOME_STRING = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        private String someString;
        private SimpleEnum type;

        private Builder() {
        }

        public final Builder from(BuilderType instance) {
            Objects.requireNonNull(instance, "instance");
            this.someString(instance.someString());
            this.type(instance.type());
            return this;
        }

        public final Builder someString(String someString) {
            this.someString = Objects.requireNonNull(someString, "someString");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(SimpleEnum type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBuilderType build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBuilderType(this.someString, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("someString");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build BuilderType, some of required attributes are not set " + attributes;
        }
    }
}

