/*
 * Decompiled with CFR 0.152.
 */
package de.drbunsen.common.fluentxmlwrapper;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lombok.NonNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FluentXmlWrapper {
    private final Element element;

    private FluentXmlWrapper(@NonNull Element element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        this.element = element;
    }

    private String getName() {
        return this.element.getTagName();
    }

    public FluentXmlWrapper addElement(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Element newChild = this.element.getOwnerDocument().createElement(name);
        this.element.appendChild(newChild);
        return FluentXmlWrapper.of(newChild);
    }

    public FluentXmlWrapper getElement(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        NodeList nodeList = this.element.getElementsByTagName(name);
        if (nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            return FluentXmlWrapper.of(node);
        }
        return null;
    }

    private static Element getElement(Node node) {
        return (Element)node;
    }

    public List<FluentXmlWrapper> getElements(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return FluentXmlWrapper.getXmlElementWrapperList(this.element.getElementsByTagName(name));
    }

    public boolean hasElement(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.getElementCount(name) > 0;
    }

    public FluentXmlWrapper removeElement(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        NodeList nodeList = this.element.getElementsByTagName(name);
        if (nodeList.getLength() > 0) {
            this.element.removeChild(nodeList.item(0));
        }
        return this;
    }

    public int getElementCount(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.element.getElementsByTagName(name).getLength();
    }

    public List<FluentXmlWrapper> getAllElements() {
        NodeList nodeList = this.element.getChildNodes();
        return FluentXmlWrapper.getXmlElementWrapperList(nodeList);
    }

    private static List<FluentXmlWrapper> getXmlElementWrapperList(NodeList nodeList) {
        ArrayList<FluentXmlWrapper> result = new ArrayList<FluentXmlWrapper>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node newElement = nodeList.item(i);
            if (newElement.getNodeType() != 1) continue;
            result.add(FluentXmlWrapper.of(newElement));
        }
        return result;
    }

    public boolean hasAttribute(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.element.hasAttribute(name);
    }

    public String getAttribute(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.element.getAttribute(name);
    }

    public FluentXmlWrapper setAttribute(@NonNull String name, @NonNull String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.element.setAttribute(name, value);
        return this;
    }

    public FluentXmlWrapper removeAttribute(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.element.removeAttribute(name);
        return this;
    }

    public String getText() {
        return this.element.getTextContent();
    }

    public FluentXmlWrapper setText(String text) {
        this.element.setTextContent(text);
        return this;
    }

    public FluentXmlWrapper getParentElement() {
        return FluentXmlWrapper.of(this.element.getParentNode());
    }

    public FluentXmlWrapper getRootElement() {
        return FluentXmlWrapper.of(this.element.getOwnerDocument().getDocumentElement());
    }

    public Element getW3cElement() {
        return this.element;
    }

    public String toXmlWithDefaultUtf8Header() throws TransformerException {
        return this.toXmlWithCustomHeader("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
    }

    public String toXmlWithoutHeader() throws TransformerException {
        return this.toXmlWithCustomHeader(null);
    }

    private String toXmlWithCustomHeader(String header) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        if (header != null) {
            writer.append(header);
            writer.append("\n");
        }
        transformer.transform(new DOMSource(this.element), new StreamResult(writer));
        return writer.getBuffer().toString();
    }

    public static FluentXmlWrapper of(Element element) {
        return new FluentXmlWrapper(element);
    }

    public static FluentXmlWrapper of(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        return FluentXmlWrapper.of(FluentXmlWrapper.getXmlDocumentFromString(xmlString).getDocumentElement());
    }

    public static FluentXmlWrapper ofNewRootElement(String rootElementName) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element rootElement = document.createElement(rootElementName);
        document.appendChild(rootElement);
        return FluentXmlWrapper.of(rootElement);
    }

    private static FluentXmlWrapper of(Node node) {
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("not an element");
        }
        return FluentXmlWrapper.of(FluentXmlWrapper.getElement(node));
    }

    private static Document getXmlDocumentFromString(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(new InputSource(new StringReader(xmlString)));
        doc.getDocumentElement().normalize();
        return doc;
    }
}

