/*
 * Decompiled with CFR 0.152.
 */
package de.dm.auth.activedirectory;

import de.dm.auth.activedirectory.ActiveDirectoryProperties;
import de.dm.auth.activedirectory.ActiveDirectoryProvider;
import de.dm.auth.activedirectory.cache.AuthenticationCacheKeyGenerator;
import de.dm.auth.activedirectory.cache.CachingAuthenticationProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.SimpleAuthorityMapper;
import org.springframework.security.ldap.authentication.ad.Hotfix3960ActiveDirectoryLdapAuthenticationProvider;

@Configuration
@EnableCaching
@EnableConfigurationProperties(value={ActiveDirectoryProperties.class})
@ConditionalOnProperty(prefix="security.activedirectory", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ActiveDirectoryAutoConfiguration {
    @Autowired
    private ActiveDirectoryProperties properties;

    @Bean
    @ActiveDirectoryProvider
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="security.activedirectory")
    public CachingAuthenticationProvider activeDirectoryLdapAuthenticationProvider() {
        Hotfix3960ActiveDirectoryLdapAuthenticationProvider provider = new Hotfix3960ActiveDirectoryLdapAuthenticationProvider(this.properties.getDomain(), this.properties.getUrl());
        provider.setSearchFilter("(&(objectClass=user)(samAccountName={1}))");
        provider.setAuthoritiesMapper(this.authoritiesMapper());
        return new CachingAuthenticationProvider((AuthenticationProvider)provider);
    }

    @Bean
    public GrantedAuthoritiesMapper authoritiesMapper() {
        SimpleAuthorityMapper simpleAuthorityMapper = new SimpleAuthorityMapper();
        simpleAuthorityMapper.setConvertToUpperCase(true);
        simpleAuthorityMapper.setDefaultAuthority("ROLE_ADMIN");
        return simpleAuthorityMapper;
    }

    @Bean
    public KeyGenerator authKeyGenerator() {
        return new AuthenticationCacheKeyGenerator();
    }

    @Bean
    public LdapContextSource ldapContextSource() {
        LdapContextSource ldapContextSource = new LdapContextSource();
        ldapContextSource.setUrl(this.properties.getUrl());
        return ldapContextSource;
    }

    @Bean
    public LdapTemplate ldapTemplateForLdapHealthCheck() {
        return new LdapTemplate((ContextSource)this.ldapContextSource());
    }
}

