/*
 * Decompiled with CFR 0.152.
 */
package de.dimensionv.java.libraries.common.utilities.enums;

import de.dimensionv.java.libraries.common.exceptions.InvalidEnumNameException;
import de.dimensionv.java.libraries.common.exceptions.InvalidEnumValueException;
import java.lang.reflect.Method;

public class EnumHelper {
    public static <T> T fromOrdinal(int ordinalValue, T[] enumValues) {
        try {
            return enumValues[ordinalValue];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new InvalidEnumValueException(ordinalValue, enumValues.length);
        }
    }

    public static <T> T fromName(String name, T[] enumValues) {
        try {
            Method nameMethod = enumValues[0].getClass().getSuperclass().getDeclaredMethod("name", new Class[0]);
            for (T value : enumValues) {
                if (!nameMethod.invoke(value, new Object[0]).equals(name)) continue;
                return value;
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("An error occurred.", ex);
        }
        throw new InvalidEnumNameException(name);
    }

    public static <T> T fromNameIgnoreCase(String name, T[] enumValues) {
        try {
            Method nameMethod = enumValues[0].getClass().getSuperclass().getDeclaredMethod("name", new Class[0]);
            for (T value : enumValues) {
                if (!((String)nameMethod.invoke(value, new Object[0])).equalsIgnoreCase(name)) continue;
                return value;
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("An error occurred.", ex);
        }
        throw new InvalidEnumNameException(name);
    }
}

